/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands.wrappers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.INonDirtying;

public class GMFtoGEFCommandWrapper
extends Command {
    private final ICommand gmfCommand;

    public GMFtoGEFCommandWrapper(ICommand command) {
        super(command.getLabel());
        this.gmfCommand = command;
    }

    public static Command wrap(ICommand command) {
        if (command instanceof INonDirtying) {
            return new NonDirtying(command);
        }
        return new GMFtoGEFCommandWrapper(command);
    }

    public ICommand getGMFCommand() {
        return this.gmfCommand;
    }

    public void dispose() {
        this.gmfCommand.dispose();
    }

    public boolean canExecute() {
        return this.gmfCommand.canExecute();
    }

    public boolean canUndo() {
        return this.gmfCommand.canUndo();
    }

    public void execute() {
        try {
            this.gmfCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.gmfCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void undo() {
        try {
            this.gmfCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public static class NonDirtying
    extends GMFtoGEFCommandWrapper
    implements INonDirtying {
        public NonDirtying(ICommand command) {
            super(command);
            if (!(command instanceof INonDirtying)) {
                throw new IllegalArgumentException("Wrapped command is not non-dirtying");
            }
        }
    }
}

