/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.INonDirtying;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFtoEMFCommandWrapper
extends AbstractCommand {
    private final ICommand gmfCommand;

    public Collection<?> getResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getGMFReturnValue() != null) {
            result.add(this.getGMFReturnValue());
        }
        return result;
    }

    private Object getGMFReturnValue() {
        if (this.getGMFCommand().getCommandResult() != null) {
            return this.getGMFCommand().getCommandResult().getReturnValue();
        }
        return null;
    }

    public GMFtoEMFCommandWrapper(ICommand gmfCommand) {
        super(gmfCommand.getLabel());
        this.gmfCommand = gmfCommand;
    }

    public static Command wrap(ICommand command) {
        if (command instanceof INonDirtying) {
            return new NonDirtying(command);
        }
        return new GMFtoEMFCommandWrapper(command);
    }

    public ICommand getGMFCommand() {
        return this.gmfCommand;
    }

    public boolean canExecute() {
        return this.gmfCommand.canExecute();
    }

    public void dispose() {
        this.gmfCommand.dispose();
    }

    public boolean canUndo() {
        return this.gmfCommand.canUndo();
    }

    public void execute() {
        try {
            this.gmfCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.gmfCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void undo() {
        try {
            this.gmfCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public Collection<?> getAffectedObjects() {
        return this.gmfCommand.getAffectedFiles();
    }

    public String getDescription() {
        return this.gmfCommand.getLabel();
    }

    public static class NonDirtying
    extends GMFtoEMFCommandWrapper
    implements AbstractCommand.NonDirtying {
        public NonDirtying(ICommand command) {
            super(command);
            if (!(command instanceof INonDirtying)) {
                throw new IllegalArgumentException("Wrapped command is not non-dirtying");
            }
        }
    }
}

