/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.generation.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ConstraintManagerImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintProvider;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsCategory;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsManager;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IValidationRule;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.papyrus.dsml.validation.wizard.CreateEMFValidationProject;
import org.eclipse.papyrus.dsml.validation.wizard.JavaContentGenerator;
import org.eclipse.papyrus.dsml.validation.wizard.ValidationPluginGenerator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Profile;

public class CreateJavaValidationPluginHandler
extends AbstractHandler {
    private IConstraintsManager constraintsManager;

    protected EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            eObject = EMFHelper.getEObject((Object)selection);
        }
        return eObject;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selection = this.getSelectedElement();
        if (selection instanceof Profile) {
            Profile profileSelection = (Profile)selection;
            this.constraintsManager = new ConstraintManagerImpl(profileSelection);
            boolean isOCLConstraint = false;
            for (IConstraintProvider constraintProvider : this.constraintsManager.getConstraintsProviders()) {
                for (IConstraintsCategory constraintCategory : constraintProvider.getConstraintsCategories()) {
                    for (IValidationRule constraint : constraintCategory.getConstraints()) {
                        if (!Utils.hasSpecificationForOCL((Constraint)constraint.getConstraint()).booleanValue()) continue;
                        isOCLConstraint = true;
                    }
                }
            }
            EPackage definition = null;
            if (isOCLConstraint && (definition = profileSelection.getDefinition()) == null) {
                NotificationBuilder errorDialog = NotificationBuilder.createErrorPopup((String)"The profile must be defined in order to generate OCL Constraints");
                errorDialog.run();
                return null;
            }
            IProject existingProject = null;
            URI uri = profileSelection.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() >= 2) {
                existingProject = root.getProject(uri.segment(1));
            }
            int question = 0;
            Shell shell = Display.getDefault().getActiveShell();
            if (existingProject != null && existingProject.exists()) {
                MessageDialog dialog = new MessageDialog(shell, "Choose plugin generation", null, "How should the plugin be generated?", 3, new String[]{"Create a new plugin", "write to plugin hosting the model or profile"}, 1);
                question = dialog.open();
            }
            if (question == 1) {
                JavaContentGenerator generateAllJava = new JavaContentGenerator(existingProject, profileSelection);
                generateAllJava.run();
                try {
                    ValidationPluginGenerator.instance.generate(existingProject, this.constraintsManager, definition);
                }
                catch (Exception e) {
                    MessageDialog.openInformation((Shell)shell, (String)"Exception occured during plugin generation", (String)e.getMessage());
                }
            } else {
                CreateEMFValidationProject wizard = new CreateEMFValidationProject(profileSelection, this.constraintsManager, definition);
                wizard.openDialog();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        EObject eObject = this.getSelectedElement();
        return eObject instanceof Profile;
    }
}

