/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;

public class ModelUtils {
    @Deprecated
    public static ModelSet getModelSet() {
        try {
            return ServiceUtilsForActionHandlers.getInstance().getModelSet();
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @Deprecated
    public static ModelSet getModelSetChecked() throws ServiceException {
        return ServiceUtilsForActionHandlers.getInstance().getModelSet();
    }

    public static ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static ModelSet getModelSetChecked(ServicesRegistry servicesRegistry) throws ServiceException {
        return servicesRegistry.getService(ModelSet.class);
    }

    public static boolean isDegradedModeAllowed(Throwable t) {
        return t instanceof ClassNotFoundException || t instanceof IllegalValueException;
    }

    public static boolean resourceFailedOnLoad(Resource r) {
        return !r.getErrors().isEmpty() && r.getContents().isEmpty();
    }

    protected static List<IModel> getOrderedModelsForLoading(final Map<String, IModel> models) {
        ArrayList<IModel> skippedModels;
        ArrayList<IModel> modelsToLoad = new ArrayList<IModel>(models.values());
        ArrayList<IModel> orderedModels = new ArrayList<IModel>();
        do {
            skippedModels = new ArrayList<IModel>();
            for (IModel model : modelsToLoad) {
                List<String> dependencies = model.getAfterLoadModelIdentifiers();
                if (dependencies == null) {
                    orderedModels.add(model);
                    continue;
                }
                Collection startedModels = Collections2.transform(dependencies, (Function)new Function<String, IModel>(){

                    public IModel apply(String arg0) {
                        return (IModel)models.get(arg0);
                    }
                });
                if (orderedModels.containsAll(startedModels)) {
                    orderedModels.add(model);
                    continue;
                }
                skippedModels.add(model);
            }
            if (skippedModels.isEmpty() || skippedModels.size() != modelsToLoad.size()) continue;
            Activator.log.error("Impossible to load models. Cycles in dependency graph for the following set of models: " + modelsToLoad, null);
            break;
        } while (!(modelsToLoad = skippedModels).isEmpty());
        return orderedModels;
    }

    public static Resource getOrCreateResource(ModelSet modelSet, boolean loadAfterCreation, URI resourceURI, String contentType) {
        Resource resource = modelSet.getResource(resourceURI, false);
        if (resource == null) {
            resource = modelSet.createResource(resourceURI, contentType);
            if (loadAfterCreation) {
                try {
                    resource.load(modelSet.getLoadOptions());
                }
                catch (IOException e) {
                    Activator.log.debug(e.getMessage());
                }
            }
        }
        return resource;
    }
}

