/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editorsfactory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.editorsfactory.IEditorFactory;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IPageModelFactory;

public class PageModelFactoryRegistry
implements IPageModelFactory {
    protected List<IEditorFactory> editorFactories = new ArrayList<IEditorFactory>();

    public IPageModel createIPageModel(Object pageIdentifier) {
        for (IEditorFactory factory : this.getEditorFactories()) {
            if (!factory.isPageModelFactoryFor(pageIdentifier)) continue;
            return factory.createIPageModel(pageIdentifier);
        }
        return null;
    }

    protected List<IEditorFactory> getEditorFactories() {
        return this.editorFactories;
    }

    public void add(IEditorFactory editorFactory) {
        if (editorFactory == null) {
            throw new RuntimeException("Parameter should not be null.");
        }
        this.editorFactories.add(editorFactory);
    }

    public void remove(IEditorFactory editorFactory) {
        this.editorFactories.remove(editorFactory);
    }
}

