/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IServiceFactory;
import org.eclipse.papyrus.infra.core.services.ModelSetServiceAdapter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;

public class ModelSetServiceFactory
implements IServiceFactory {
    private ServicesRegistry serviceRegistry;
    private ModelSet service;

    @Override
    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.serviceRegistry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
    }

    @Override
    public void disposeService() throws ServiceException {
        if (this.service != null) {
            try {
                ModelSetServiceFactory.setServiceRegistry((ResourceSet)this.service, null);
            }
            finally {
                this.service.unload();
            }
        }
    }

    @Override
    public final Object createServiceInstance() throws ServiceException {
        if (this.service == null) {
            this.service = this.createModelSet();
            ModelSetServiceFactory.setServiceRegistry((ResourceSet)this.service, this.serviceRegistry);
        }
        return this.service;
    }

    protected ModelSet createModelSet() {
        return new DiResourceSet();
    }

    public static ServicesRegistry getServiceRegistry(ResourceSet resourceSet) {
        ModelSetServiceAdapter adapter = ModelSetServiceAdapter.getInstance(resourceSet);
        return adapter == null ? null : adapter.getServiceRegistry();
    }

    public static void setServiceRegistry(ResourceSet resourceSet, ServicesRegistry serviceRegistry) throws ServiceException {
        if (serviceRegistry != null) {
            ModelSetServiceAdapter adapter = new ModelSetServiceAdapter(resourceSet);
            adapter.init(serviceRegistry);
            adapter.startService();
        } else {
            ModelSetServiceAdapter adapter = ModelSetServiceAdapter.getInstance(resourceSet);
            if (adapter != null) {
                adapter.stopService();
            }
        }
    }
}

