/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.EvictionEventImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.ReferenceQueueWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCDORevisionCache
extends ReferenceQueueWorker<InternalCDORevision>
implements InternalCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, AbstractCDORevisionCache.class);
    private static boolean disableGC;
    private CDOBranchManager branchManager;
    private String name;

    public AbstractCDORevisionCache() {
        this.setDaemon(true);
    }

    public CDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    public void setBranchManager(CDOBranchManager branchManager) {
        this.branchManager = branchManager;
    }

    protected final void checkBranch(CDOBranch branch) {
        CDOBranchManager actualBranchManager;
        if (this.branchManager != null && (actualBranchManager = branch.getBranchManager()) != this.branchManager) {
            throw new IllegalArgumentException("Wrong branch manager: " + actualBranchManager + "; expected: " + this.branchManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.formatName("CDORevisionCache");
    }

    protected String getThreadName() {
        return this.formatName("CDORevisionCacheCleaner");
    }

    private String formatName(String prefix) {
        return String.valueOf(prefix) + (this.name == null ? "" : "-" + this.name);
    }

    protected void work(Reference<? extends InternalCDORevision> reference) {
        IListener[] listeners;
        int version;
        CDOBranch branch;
        CDORevisionKey key = (CDORevisionKey)((Object)reference);
        CDOID id = key.getID();
        InternalCDORevision revision = (InternalCDORevision)this.removeRevision(id, (branch = key.getBranch()).getVersion(version = key.getVersion()));
        if (revision == null) {
            key = revision;
        }
        if ((listeners = this.getListeners()) != null) {
            this.fireEvent(new EvictionEventImpl(this, key), listeners);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Evicted {0} from {1}", new Object[]{key, this});
        }
    }

    protected Reference<InternalCDORevision> createReference(CDORevision revision) {
        if (disableGC) {
            return this.createStrongReference(revision);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision {0} to {1}", new Object[]{revision, this});
        }
        return new CacheSoftReference((InternalCDORevision)revision, this.getQueue());
    }

    private Reference<InternalCDORevision> createStrongReference(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision {0} to {1} (STRONGLY REFERENCED)", new Object[]{revision, this});
        }
        return new CacheStrongReference((InternalCDORevision)revision);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheSoftReference
    extends SoftReference<InternalCDORevision>
    implements CDORevisionKey {
        private CDOID id;
        private CDOBranch branch;
        private int version;

        public CacheSoftReference(InternalCDORevision revision, ReferenceQueue<InternalCDORevision> queue) {
            super(revision, queue);
            this.id = revision.getID();
            this.branch = revision.getBranch();
            this.version = revision.getVersion();
        }

        @Override
        public CDOID getID() {
            return this.id;
        }

        @Override
        public CDOBranch getBranch() {
            return this.branch;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}v{2}", this.getID(), this.getBranch().getID(), this.getVersion());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheStrongReference
    extends SoftReference<InternalCDORevision>
    implements CDORevisionKey {
        private CDOID id;
        private CDOBranch branch;
        private int version;

        public CacheStrongReference(InternalCDORevision revision) {
            super(revision);
            this.id = revision.getID();
            this.branch = revision.getBranch();
            this.version = revision.getVersion();
        }

        @Override
        public CDOID getID() {
            return this.id;
        }

        @Override
        public CDOBranch getBranch() {
            return this.branch;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}v{2}", this.getID(), this.getBranch().getID(), this.getVersion());
        }
    }
}

