/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeKindCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.net4j.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOChangeSetDataImpl
implements CDOChangeSetData {
    private List<CDOIDAndVersion> newObjects;
    private List<CDORevisionKey> changedObjects;
    private List<CDOIDAndVersion> detachedObjects;
    private CDOChangeKindCache changeKindCache;

    public CDOChangeSetDataImpl(List<CDOIDAndVersion> newObjects, List<CDORevisionKey> changedObjects, List<CDOIDAndVersion> detachedObjects) {
        this.newObjects = newObjects;
        this.changedObjects = changedObjects;
        this.detachedObjects = detachedObjects;
    }

    public CDOChangeSetDataImpl() {
        this(new ArrayList<CDOIDAndVersion>(), new ArrayList<CDORevisionKey>(), new ArrayList<CDOIDAndVersion>());
    }

    @Override
    public boolean isEmpty() {
        if (this.newObjects != null && !this.newObjects.isEmpty()) {
            return false;
        }
        if (this.changedObjects != null && !this.changedObjects.isEmpty()) {
            return false;
        }
        return this.detachedObjects == null || this.detachedObjects.isEmpty();
    }

    @Override
    public CDOChangeSetData copy() {
        ArrayList<CDOIDAndVersion> newObjectsCopy = new ArrayList<CDOIDAndVersion>(this.newObjects.size());
        for (CDOIDAndVersion key : this.newObjects) {
            if (key instanceof CDORevision) {
                CDORevision revision = (CDORevision)key;
                newObjectsCopy.add(revision.copy());
                continue;
            }
            newObjectsCopy.add(key);
        }
        ArrayList<CDORevisionKey> changedObjectsCopy = new ArrayList<CDORevisionKey>(this.changedObjects.size());
        for (CDORevisionKey key : this.changedObjects) {
            if (key instanceof CDORevisionDelta) {
                CDORevisionDelta delta = (CDORevisionDelta)key;
                changedObjectsCopy.add(delta.copy());
                continue;
            }
            changedObjectsCopy.add(key);
        }
        ArrayList<CDOIDAndVersion> detachedObjectsCopy = new ArrayList<CDOIDAndVersion>(this.detachedObjects.size());
        for (CDOIDAndVersion key : this.detachedObjects) {
            detachedObjectsCopy.add(key);
        }
        return new CDOChangeSetDataImpl(newObjectsCopy, changedObjectsCopy, detachedObjectsCopy);
    }

    @Override
    public void merge(CDOChangeSetData changeSetData) {
        Map<CDOID, CDOIDAndVersion> newMap = CDOIDUtil.createMap();
        CDOChangeSetDataImpl.fillMap(newMap, this.newObjects);
        CDOChangeSetDataImpl.fillMap(newMap, changeSetData.getNewObjects());
        Map<CDOID, CDORevisionKey> changedMap = CDOIDUtil.createMap();
        CDOChangeSetDataImpl.fillMap(changedMap, this.changedObjects);
        for (CDORevisionKey key : changeSetData.getChangedObjects()) {
            this.mergeChangedObject(key, newMap, changedMap);
        }
        Map<CDOID, CDOIDAndVersion> detachedMap = CDOIDUtil.createMap();
        CDOChangeSetDataImpl.fillMap(detachedMap, this.detachedObjects);
        for (CDOIDAndVersion key : changeSetData.getDetachedObjects()) {
            CDOID id = key.getID();
            if (newMap.remove(id) != null) continue;
            detachedMap.put(id, key);
        }
        this.newObjects = new ArrayList<CDOIDAndVersion>(newMap.values());
        this.changedObjects = new ArrayList<CDORevisionKey>(changedMap.values());
        this.detachedObjects = new ArrayList(detachedMap.values());
    }

    private void mergeChangedObject(CDORevisionKey key, Map<CDOID, CDOIDAndVersion> newMap, Map<CDOID, CDORevisionKey> changedMap) {
        CDOID id = key.getID();
        if (key instanceof CDORevisionDelta) {
            CDORevisionDelta delta = (CDORevisionDelta)key;
            CDOIDAndVersion oldRevision = newMap.get(id);
            if (oldRevision instanceof CDORevision) {
                CDORevision newRevision = (CDORevision)oldRevision;
                delta.applyTo(newRevision);
                return;
            }
            CDORevisionKey oldDelta = changedMap.get(id);
            if (oldDelta instanceof CDORevisionDelta) {
                InternalCDORevisionDelta newDelta = (InternalCDORevisionDelta)oldDelta;
                for (CDOFeatureDelta featureDelta : delta.getFeatureDeltas()) {
                    newDelta.addFeatureDelta(featureDelta, null);
                }
                return;
            }
        }
        changedMap.put(id, key);
    }

    @Override
    public List<CDOIDAndVersion> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public List<CDORevisionKey> getChangedObjects() {
        return this.changedObjects;
    }

    @Override
    public List<CDOIDAndVersion> getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public synchronized Map<CDOID, CDOChangeKind> getChangeKinds() {
        if (this.changeKindCache == null) {
            this.changeKindCache = new CDOChangeKindCache(this);
        }
        return this.changeKindCache;
    }

    @Override
    public CDOChangeKind getChangeKind(CDOID id) {
        return this.getChangeKinds().get(id);
    }

    public String toString() {
        return MessageFormat.format("ChangeSetData[newObjects={0}, changedObjects={1}, detachedObjects={2}]", this.newObjects.size(), this.changedObjects.size(), this.detachedObjects.size());
    }

    public static String format(CDOChangeSetData changeSetData) {
        StringBuilder builder = new StringBuilder();
        builder.append(changeSetData);
        builder.append(StringUtil.NL);
        CDOChangeSetDataImpl.format(builder, "  New Objects:", changeSetData.getNewObjects());
        CDOChangeSetDataImpl.format(builder, "  Changed Objects:", changeSetData.getChangedObjects());
        CDOChangeSetDataImpl.format(builder, "  Detached Objects:", changeSetData.getDetachedObjects());
        return builder.toString();
    }

    private static void format(StringBuilder builder, String label, List<?> objects) {
        builder.append(label);
        builder.append(StringUtil.NL);
        for (Object object : objects) {
            builder.append("    ");
            builder.append(object);
            builder.append(StringUtil.NL);
        }
    }

    private static <T extends CDOIDAndVersion> void fillMap(Map<CDOID, T> map, Collection<T> c) {
        for (CDOIDAndVersion key : c) {
            map.put(key.getID(), key);
        }
    }
}

