/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.ObjectUtil;

public final class CDOClassifierRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String URI_SEPARATOR = "#";
    private String packageURI;
    private String classifierName;

    public CDOClassifierRef() {
    }

    public CDOClassifierRef(EClassifier classifier) {
        this(classifier.getEPackage().getNsURI(), classifier.getName());
    }

    public CDOClassifierRef(String packageURI, String classifierName) {
        this.packageURI = packageURI.intern();
        this.classifierName = classifierName.intern();
    }

    public CDOClassifierRef(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("CDOClassifierRef.1")) + uri);
        }
        int hash = uri.lastIndexOf(URI_SEPARATOR);
        if (hash == -1) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("CDOClassifierRef.1")) + uri);
        }
        this.packageURI = uri.substring(0, hash);
        this.classifierName = uri.substring(hash + 1);
    }

    public CDOClassifierRef(CDODataInput in) throws IOException {
        this(in.readCDOPackageURI());
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOPackageURI(this.getURI());
    }

    public String getURI() {
        return String.valueOf(this.packageURI) + URI_SEPARATOR + this.classifierName;
    }

    public String getPackageURI() {
        return this.packageURI;
    }

    public String getClassifierName() {
        return this.classifierName;
    }

    public EClassifier resolve(EPackage.Registry packageRegistry) {
        EPackage ePackage = packageRegistry.getEPackage(this.packageURI);
        if (ePackage == null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOClassifierRef.0"), this.packageURI));
        }
        return ePackage.getEClassifier(this.classifierName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == CDOClassifierRef.class) {
            CDOClassifierRef that = (CDOClassifierRef)obj;
            return ObjectUtil.equals((Object)this.packageURI, (Object)that.packageURI) && ObjectUtil.equals((Object)this.classifierName, (Object)that.classifierName);
        }
        return false;
    }

    public int hashCode() {
        return this.packageURI.hashCode() ^ this.classifierName.hashCode();
    }

    public String toString() {
        return MessageFormat.format("CDOClassifierRef({0}, {1})", this.packageURI, this.classifierName);
    }

    public static interface Provider {
        public CDOClassifierRef getClassifierRef();
    }
}

