/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.log;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class LogHelper {
    private String pluginId;
    private Plugin activator;

    public LogHelper() {
    }

    public LogHelper(Plugin activator) {
        this.setPlugin(activator);
    }

    public void setPlugin(Plugin activator) {
        this.pluginId = activator.getBundle().getSymbolicName();
        this.activator = activator;
    }

    public void info(String message) {
        this.log(message, 1);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log("[DEBUG] " + message, 1);
        }
    }

    public boolean isDebugEnabled() {
        if (this.activator != null) {
            return Platform.inDebugMode();
        }
        return false;
    }

    private void log(String message, int level) {
        this.log((IStatus)new Status(level, this.pluginId, message));
    }

    private void log(IStatus status) {
        if (this.activator != null) {
            this.activator.getLog().log(status);
        }
    }

    public void warn(String message) {
        this.log(message, 2);
    }

    public void error(Throwable e) {
        this.error("Unexpected Error", e);
    }

    public void error(String message, Throwable e) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
        }
        Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, this.pluginId, message, e);
        this.log((IStatus)status);
    }

    public String getCallerMethod() {
        StackTraceElement[] stack = new Exception().fillInStackTrace().getStackTrace();
        return stack == null || stack.length < 3 ? "<unknown caller>" : stack[2].toString();
    }
}

