/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime.notifier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.layers.stackmodel.layers.RegExpLayer;

public abstract class AbstractDerivedViewLayerNotifier {
    protected List<RegExpLayer> listeners = new ArrayList<RegExpLayer>();
    private boolean isListening = false;

    public void addListener(RegExpLayer listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this.checkStartListening();
        }
    }

    public void removeListener(RegExpLayer listener) {
        this.listeners.remove(listener);
        this.checkStopListening();
    }

    public void removeAllListeners() {
        this.isListening = false;
        this.listeners.clear();
        this.stopListening();
    }

    private void checkStartListening() {
        if (!this.isListening() && this.listeners.size() > 0) {
            this.isListening = true;
            this.startListening();
        }
    }

    private void checkStopListening() {
        if (this.isListening() && this.listeners.size() == 0) {
            this.isListening = false;
            this.stopListening();
        }
    }

    public void fireEvent() {
        for (RegExpLayer regExpLayer : this.listeners) {
        }
    }

    protected abstract void startListening();

    protected abstract void stopListening();

    public boolean isListening() {
        return this.isListening;
    }
}

