/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NotationDiagramMngrTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        this.modelSet = mngr;
    }

    @After
    public void tearDown() throws Exception {
        this.modelSet.unload();
    }

    @Test
    public void testNotationDiagramHelper() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        NotationDiagramHelper diagramHelper = new NotationDiagramHelper(layersModel, diagram);
        Assert.assertNotNull((String)"ManagerCreated", (Object)diagramHelper);
    }

    @Test
    public void testDispose() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        NotationDiagramHelper diagramHelper = new NotationDiagramHelper(layersModel, diagram);
        diagramHelper.dispose();
        Assert.assertNull((String)"disposed", (Object)diagramHelper.getDiagram());
    }

    @Test
    public void testGetDiagram() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        NotationDiagramHelper diagramHelper = new NotationDiagramHelper(layersModel, diagram);
        Assert.assertNotNull((String)"getDiagram", (Object)diagramHelper.getDiagram());
        Assert.assertSame((String)"getDiagram", (Object)diagram, (Object)diagramHelper.getDiagram());
    }

    @Test
    public void testAttachLayerStack() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        NotationDiagramHelper diagramHelper = new NotationDiagramHelper(layersModel, diagram);
        diagramHelper.attachLayersStack();
        Assert.assertTrue((String)"LayerStack is attached to diagram", (boolean)diagramHelper.isLayersStackAttached());
    }

    @Test
    public void testRemoveLayerStack() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        NotationDiagramHelper diagramHelper = new NotationDiagramHelper(layersModel, diagram);
        diagramHelper.attachLayersStack();
        Assert.assertTrue((String)"LayerStack is attached to diagram", (boolean)diagramHelper.isLayersStackAttached());
        diagramHelper.removeLayersStack();
        Assert.assertFalse((String)"LayerStack is detached from diagram", (boolean)diagramHelper.isLayersStackAttached());
    }

    @Test
    public void testIsLayerStackAttached() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        NotationDiagramHelper diagramHelper = new NotationDiagramHelper(layersModel, diagram);
    }
}

