/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.papyrus.layers.runtime.ILayersStackApplicationEventListener;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;

public class LayersStackApplicationEventNotifier {
    protected LayersModel layersModel;
    protected List<ILayersStackApplicationEventListener> listeners = new ArrayList<ILayersStackApplicationEventListener>();
    protected Adapter layerStackListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            block0 : switch (msg.getFeatureID(LayersStackApplication.class)) {
                case 0: {
                    switch (msg.getEventType()) {
                        case 3: {
                            LayersStackApplicationEventNotifier.this.layerStackAdded(msg);
                            break block0;
                        }
                        case 4: {
                            LayersStackApplicationEventNotifier.this.layerStackRemoved(msg);
                            break block0;
                        }
                    }
                }
            }
        }
    };

    public LayersStackApplicationEventNotifier(LayersModel layersModel) {
        this.layersModel = layersModel;
        this.activate();
    }

    public LayersStackApplicationEventNotifier(LayersModel layersModel, boolean activate) {
        this.layersModel = layersModel;
        if (activate) {
            this.activate();
        }
    }

    protected void activate() {
        LayersStackApplication application = this.layersModel.getLayerStackApplication();
        application.eAdapters().add((Object)this.layerStackListener);
    }

    protected void deactivate() {
        LayersStackApplication application = this.layersModel.lookupLayerStackApplication();
        if (application != null) {
            application.eAdapters().remove((Object)this.layerStackListener);
        }
    }

    protected void dispose() {
        this.deactivate();
        this.layersModel = null;
    }

    protected boolean isDisposed() {
        return this.layersModel == null;
    }

    public void addLayersModelEventListener(ILayersStackApplicationEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeLayersModelEventListener(ILayersStackApplicationEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void layerStackAdded(Notification msg) {
        for (ILayersStackApplicationEventListener listener : this.listeners) {
            listener.layerStackAdded(msg);
        }
    }

    protected void layerStackRemoved(Notification msg) {
        for (ILayersStackApplicationEventListener listener : this.listeners) {
            listener.layerStackRemoved(msg);
        }
    }

    public static LayersStack getAddedLayerStack(Notification msg) {
        return (LayersStack)msg.getNewValue();
    }

    public static LayersStack getRemovedLayerStack(Notification msg) {
        return (LayersStack)msg.getOldValue();
    }
}

