/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.LayerStackApplicationSynchronizer;
import org.eclipse.papyrus.layers.runtime.LayerStackApplicationSynchronizerSubclass;
import org.eclipse.papyrus.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.runtime.utils.TriggeredEventTraces;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerStackApplicationSynchronizerEventTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        NotationModel notationModel = new NotationModel();
        mngr.registerModel((IModel)notationModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        this.modelSet = mngr;
    }

    @After
    public void tearDown() throws Exception {
        this.modelSet.unload();
    }

    @Test
    public void testModelSetCreation() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        Assert.assertNotNull((String)"NotationModel is created", (Object)notationModel);
        notationModel.addDiagram(NotationFactory.eINSTANCE.createDiagram());
        Assert.assertNotNull((String)"Diagram is in the roots", (Object)notationModel.getResource().getContents().get(0));
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Assert.assertNotNull((String)"LayerModel is created", (Object)((Object)layersModel));
        Assert.assertNotNull((String)"LayerStackApplication is created", (Object)layersModel.getLayerStackApplication());
    }

    @Test
    public void testLayerStackApplicationSynchronizer() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        synchronizer.dispose();
    }

    @Test
    public void testDispose() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)((Object)synchronizer.getLayersModel()));
        synchronizer.dispose();
        Assert.assertNull((String)"object is disposed", (Object)((Object)synchronizer.getLayersModel()));
    }

    @Test
    public void testLayerAddedEventListener() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        TriggeredEventTraces traces = new TriggeredEventTraces();
        LayerStackApplicationSynchronizerSubclass synchronizer = new LayerStackApplicationSynchronizerSubclass(layersModel, notationModel, traces);
        helper.attachLayersStack();
        Assert.assertEquals((String)"event catched", (Object)"layerStackAdded", (Object)traces.get((int)0).name);
        Assert.assertTrue((String)"event catched", (boolean)traces.contains("layerStackAdded"));
        synchronizer.dispose();
    }

    @Test
    public void testLayerRemovedEventListener() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        TriggeredEventTraces traces = new TriggeredEventTraces();
        LayerStackApplicationSynchronizerSubclass synchronizer = new LayerStackApplicationSynchronizerSubclass(layersModel, notationModel, traces);
        helper.attachLayersStack();
        traces.clear();
        helper.removeLayersStack();
        Assert.assertTrue((String)"event catched", (boolean)traces.contains("layerStackRemoved"));
        synchronizer.dispose();
    }

    @Test
    public void testDiagramRemovedEventListener() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram1 = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram1);
        NotationDiagramHelper helperForDiag1 = new NotationDiagramHelper(layersModel, diagram1);
        Diagram diagram2 = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram2);
        NotationDiagramHelper helperForDiag2 = new NotationDiagramHelper(layersModel, diagram2);
        TriggeredEventTraces traces = new TriggeredEventTraces();
        LayerStackApplicationSynchronizerSubclass synchronizer = new LayerStackApplicationSynchronizerSubclass(layersModel, notationModel, traces);
        helperForDiag1.attachLayersStack();
        helperForDiag2.attachLayersStack();
        traces.clear();
        notationModel.getResource().getContents().remove((Object)diagram2);
        Assert.assertTrue((String)"event catched", (boolean)traces.contains("diagramRemoved"));
        Assert.assertEquals((String)"diagram found in notification", (Object)diagram2, (Object)traces.getFirstEvent((String)"diagramRemoved").notifier.getOldValue());
        synchronizer.dispose();
    }
}

