/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.layers.runtime.TraceDiagramViewEventListener;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.IDiagramViewEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class DiagramViewEventNotifierTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDiagramViewEventNotifier() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramViewEventNotifier notifier = new DiagramViewEventNotifier(diagram);
        Assert.assertNotNull((String)"notifier created", (Object)notifier);
        notifier.dispose();
    }

    @Test
    public void testDispose() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramViewEventNotifier notifier = new DiagramViewEventNotifier(diagram);
        Assert.assertNotNull((String)"notifier created", (Object)notifier);
        Assert.assertFalse((String)"notifier is disposed", (boolean)notifier.isDisposed());
        notifier.dispose();
        Assert.assertTrue((String)"notifier is disposed", (boolean)notifier.isDisposed());
    }

    @Test
    @Ignore
    public void testAddEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testRemoveEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testFireDiagramViewAddedEvent() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramViewEventNotifier notifier = new DiagramViewEventNotifier(diagram);
        TraceDiagramViewEventListener listener = new TraceDiagramViewEventListener();
        notifier.addEventListener((IDiagramViewEventListener)listener);
        Node node1 = diagram.createChild(NotationPackage.eINSTANCE.getShape());
        Assert.assertEquals((String)"event found", (Object)"diagramViewAdded", (Object)listener.traces.get((int)0).name);
        listener.traces.clear();
        node1.createChild(NotationPackage.eINSTANCE.getShape());
        Assert.assertEquals((String)"event found", (Object)"diagramViewAdded", (Object)listener.traces.get((int)0).name);
    }

    @Test
    public void testFireDiagramViewRemovedEvent() {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramViewEventNotifier notifier = new DiagramViewEventNotifier(diagram);
        TraceDiagramViewEventListener listener = new TraceDiagramViewEventListener();
        notifier.addEventListener((IDiagramViewEventListener)listener);
        Node node1 = diagram.createChild(NotationPackage.eINSTANCE.getShape());
        listener.traces.clear();
        node1.createChild(NotationPackage.eINSTANCE.getShape());
        Assert.assertTrue((String)"event found", (boolean)diagram.getChildren().contains((Object)node1));
        listener.traces.clear();
        diagram.removeChild((View)node1);
        Assert.assertFalse((String)"event found", (boolean)diagram.getChildren().contains((Object)node1));
        Assert.assertTrue((String)"event found", (boolean)listener.traces.contains("diagramViewRemoved"));
    }
}

