/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences.BlockDefinitionDiagramNodePreferencePage;

public class PackagePreferencePage
extends BlockDefinitionDiagramNodePreferencePage {
    protected static String prefKey = "BlockDefinition_Package";
    public static final Map<String, Boolean> compartmentDefaultVisibilityMap = new LinkedHashMap<String, Boolean>();
    public static final Map<String, Boolean> compartmentTitleDefaultVisibilityMap;

    static {
        compartmentDefaultVisibilityMap.put("PackageableElementCompartment", Boolean.TRUE);
        compartmentTitleDefaultVisibilityMap = new LinkedHashMap<String, Boolean>();
        compartmentTitleDefaultVisibilityMap.put("PackageableElementCompartment", Boolean.FALSE);
        Collections.unmodifiableMap(compartmentDefaultVisibilityMap);
        Collections.unmodifiableMap(compartmentTitleDefaultVisibilityMap);
    }

    public PackagePreferencePage() {
        this.setPreferenceKey("BlockDefinition_Package");
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(PreferencesConstantsHelper.getElementConstant((String)prefKey, (int)17), 200);
        store.setDefault(PreferencesConstantsHelper.getElementConstant((String)prefKey, (int)16), 100);
        for (String compartmentName : compartmentDefaultVisibilityMap.keySet()) {
            String showCompartmentKey = PreferencesConstantsHelper.getCompartmentElementConstant((String)prefKey, (String)compartmentName, (int)18);
            store.setDefault(showCompartmentKey, compartmentDefaultVisibilityMap.get(compartmentName).booleanValue());
        }
        for (String compartmentName : compartmentTitleDefaultVisibilityMap.keySet()) {
            String showCompartmentTitleKey = PreferencesConstantsHelper.getCompartmentElementConstant((String)prefKey, (String)compartmentName, (int)19);
            store.setDefault(showCompartmentTitleKey, compartmentTitleDefaultVisibilityMap.get(compartmentName).booleanValue());
        }
    }

    protected void initializeCompartmentNamesList() {
        for (String name : compartmentDefaultVisibilityMap.keySet()) {
            this.compartmentNamesList.add(name);
        }
    }

    protected void initializeCompartmentTitlesList() {
        for (String name : compartmentTitleDefaultVisibilityMap.keySet()) {
            this.compartmentTitlesList.add(name);
        }
    }
}

