/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.importsources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.importsources.CompositePackageImportSource;
import org.eclipse.papyrus.uml.tools.importsources.IPackageImportSource;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageImportSourceRegistry
implements Iterable<Descriptor> {
    private static final String EXTPT_ID = "org.eclipse.papyrus.uml.tools.importSources";
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final IEvaluationService evaluationService;

    public PackageImportSourceRegistry(IEvaluationService evaluationService) {
        this.evaluationService = evaluationService;
        for (IConfigurationElement config : this.sort(Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPT_ID))) {
            if (!"importSource".equals(config.getName())) continue;
            this.descriptors.add(new Descriptor(config));
        }
    }

    @Override
    public Iterator<Descriptor> iterator() {
        return this.descriptors.iterator();
    }

    public int size() {
        return this.descriptors.size();
    }

    public IPackageImportSource createImportSourceFor(Collection<?> selection) {
        ArrayList<IPackageImportSource> result = new ArrayList<IPackageImportSource>(3);
        for (Descriptor next : this) {
            if (!next.canImportInto(selection)) continue;
            result.add(next.getInstance());
        }
        return result.isEmpty() ? new NullImportSource() : (result.size() == 1 ? (IPackageImportSource)result.get(0) : new CompositePackageImportSource(result));
    }

    private List<IConfigurationElement> sort(IConfigurationElement[] providerElements) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>(Arrays.asList(providerElements));
        Collections.sort(result, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String plugin2;
                String plugin1 = o1.getContributor().getName();
                int result = plugin1.equals(plugin2 = o2.getContributor().getName()) ? 0 : ("org.eclipse.papyrus.uml.tools".equals(plugin1) ? 1 : ("org.eclipse.papyrus.uml.tools".equals(plugin2) ? -1 : 0));
                return result;
            }
        });
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Descriptor
    implements IPackageImportSource {
        private final IConfigurationElement config;
        private String label;
        private Expression matchSelection;
        private IPackageImportSource instance;

        Descriptor(IConfigurationElement config) {
            this.config = config;
            this.label = config.getAttribute("name");
            this.initMatchExpression(config);
        }

        public String getLabel() {
            return this.label;
        }

        IPackageImportSource getInstance() {
            if (this.instance == null) {
                try {
                    this.instance = (IPackageImportSource)this.config.createExecutableExtension("class");
                }
                catch (ClassCastException e) {
                    Activator.log.error("Import source does not implement IPackageImportSource interface.", (Throwable)e);
                }
                catch (Exception e) {
                    Activator.log.error("Could not instantiate storage provider.", (Throwable)e);
                }
                if (this.instance == null) {
                    this.instance = new NullImportSource();
                }
            }
            return this.instance;
        }

        @Override
        public boolean canImportInto(Collection<?> initialSelection) {
            boolean result;
            if (this.matchSelection != null) {
                EvaluationContext ctx = new EvaluationContext(PackageImportSourceRegistry.this.evaluationService.getCurrentState(), initialSelection);
                EvaluationResult evalResult = EvaluationResult.FALSE;
                try {
                    evalResult = this.matchSelection.evaluate((IEvaluationContext)ctx);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
                result = EvaluationResult.TRUE.equals(evalResult);
            } else {
                result = this.getInstance().canImportInto(initialSelection);
            }
            return result;
        }

        @Override
        public void initialize(Collection<?> selection) {
            this.getInstance().initialize(selection);
        }

        @Override
        public IStaticContentProvider getModelHierarchyContentProvider(Map<String, String> extensionFilters) {
            return this.getInstance().getModelHierarchyContentProvider(extensionFilters);
        }

        @Override
        public ILabelProvider getModelHierarchyLabelProvider() {
            return this.getInstance().getModelHierarchyLabelProvider();
        }

        @Override
        public List<Package> getPackages(ResourceSet resourceSet, Object model) throws CoreException {
            return this.getInstance().getPackages(resourceSet, model);
        }

        @Override
        public void dispose() {
            if (this.instance != null) {
                this.instance.dispose();
                this.instance = null;
            }
        }

        private void initMatchExpression(IConfigurationElement parentConfig) {
            IConfigurationElement[] configs = parentConfig.getChildren("enablement");
            if (configs.length > 0) {
                try {
                    this.matchSelection = ExpressionConverter.getDefault().perform(configs[0]);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullImportSource
    implements IPackageImportSource {
        private NullImportSource() {
        }

        @Override
        public boolean canImportInto(Collection<?> selection) {
            return false;
        }

        @Override
        public void initialize(Collection<?> selection) {
        }

        @Override
        public IStaticContentProvider getModelHierarchyContentProvider(Map<String, String> extensionFilters) {
            return null;
        }

        @Override
        public ILabelProvider getModelHierarchyLabelProvider() {
            return null;
        }

        @Override
        public List<Package> getPackages(ResourceSet resourceSet, Object model) throws CoreException {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.tools", "Null import source should not be invoked to import packages."));
        }

        @Override
        public void dispose() {
        }
    }
}

