/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.util.MultiplicityParser;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;

public class SetMultiplicityCommand
extends CompoundCommand {
    private int[] lowerUpper;
    private MultiplicityElement element;
    static EStructuralFeature lowerFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Lower();
    static EStructuralFeature upperFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Upper();

    public SetMultiplicityCommand(MultiplicityElement element, String value) {
        if (element == null) {
            return;
        }
        int[] lowerUpper = MultiplicityParser.getBounds(value);
        if (lowerUpper == null || lowerUpper.length < 2) {
            return;
        }
        int lower = lowerUpper[0];
        int upper = lowerUpper[1];
        if (!MultiplicityParser.isValidMultiplicity(lower, upper)) {
            return;
        }
        this.lowerUpper = lowerUpper;
        this.element = element;
        this.append(this.getSetCommand(lowerFeature, lower));
        this.append(this.getSetCommand(upperFeature, upper));
    }

    private Command getSetCommand(EStructuralFeature feature, int value) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.element);
        if (provider != null) {
            SetRequest request = new SetRequest((EObject)this.element, feature, (Object)value);
            ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            return emfCommand;
        }
        return null;
    }

    public boolean canExecute() {
        return this.element != null && this.lowerUpper != null && this.lowerUpper.length == 2 && super.canExecute();
    }
}

