/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.source.JavadocFormatter;
import net.sf.jautodoc.source.SourceManipulator;
import net.sf.jautodoc.utils.Utils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class JAutodocTask
extends Task {
    private static final String DEFAULT_SRCDIR = "src";
    private static final String DEFAULT_INCLUDE = "**/*.java";
    private static final String COMPLETE = "complete";
    private static final String KEEP = "keep";
    private static final String REPLACE = "replace";
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private Configuration config;
    private String srcdir;
    private String includes;
    private String excludes;
    private boolean verbose = false;
    private String mode;
    private Boolean commentPublic;
    private Boolean commentPackage;
    private Boolean commentProtected;
    private Boolean commentPrivate;
    private Boolean commentTypes;
    private Boolean commentFields;
    private Boolean commentMethods;
    private Boolean getsetOnly;
    private Boolean excludeGetset;
    private Boolean todo;
    private Boolean comment;
    private Boolean single;
    private Boolean format;
    private Boolean getsetFromField;
    private Boolean getsetFromFieldFirst;
    private Boolean getsetFromFieldReplace;
    private Boolean includeSubpackages;
    private Boolean header;
    private Boolean replaceHeader;
    private Boolean multiHeader;
    private boolean headerOnly;

    public void setSrcdir(String srcdir) {
        this.srcdir = srcdir;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setPublic(Boolean commentPublic) {
        this.commentPublic = commentPublic;
    }

    public void setPackage(Boolean commentPackage) {
        this.commentPackage = commentPackage;
    }

    public void setProtected(Boolean commentProtected) {
        this.commentProtected = commentProtected;
    }

    public void setPrivate(Boolean commentPrivate) {
        this.commentPrivate = commentPrivate;
    }

    public void setTypes(Boolean commentTypes) {
        this.commentTypes = commentTypes;
    }

    public void setFields(Boolean commentFields) {
        this.commentFields = commentFields;
    }

    public void setMethods(Boolean commentMethods) {
        this.commentMethods = commentMethods;
    }

    public void setGetsetOnly(Boolean getsetOnly) {
        this.getsetOnly = getsetOnly;
    }

    public void setExcludeGetset(Boolean excludeGetset) {
        this.excludeGetset = excludeGetset;
    }

    public void setTodo(Boolean todo) {
        this.todo = todo;
    }

    public void setComment(Boolean comment) {
        this.comment = comment;
    }

    public void setSingle(Boolean single) {
        this.single = single;
    }

    public void setFormat(Boolean format) {
        this.format = format;
    }

    public void setGetsetFromField(Boolean getsetFromField) {
        this.getsetFromField = getsetFromField;
    }

    public void setGetsetFromFieldFirst(Boolean getsetFromFieldFirst) {
        this.getsetFromFieldFirst = getsetFromFieldFirst;
    }

    public void setGetsetFromFieldReplace(Boolean getsetFromFieldReplace) {
        this.getsetFromFieldReplace = getsetFromFieldReplace;
    }

    public void setIncludeSubpackages(Boolean includeSubpackages) {
        this.includeSubpackages = includeSubpackages;
    }

    public void setHeader(Boolean header) {
        this.header = header;
    }

    public void setReplaceHeader(Boolean replaceHeader) {
        this.replaceHeader = replaceHeader;
    }

    public void setMultiHeader(Boolean multiHeader) {
        this.multiHeader = multiHeader;
    }

    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    public void execute() throws BuildException {
        this.validateProperties();
        this.log("Creating Javadoc...");
        try {
            ICompilationUnit[] compUnits = this.findCompilationUnits();
            if (compUnits.length == 0) {
                return;
            }
            NullProgressMonitor monitor = null;
            Hashtable references = this.getProject().getReferences();
            if (references != null) {
                monitor = (IProgressMonitor)references.get("eclipse.progress.monitor");
            }
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            this.createJavadoc(compUnits, (IProgressMonitor)new ProgressMonitor((IProgressMonitor)monitor, 1));
            this.log("Done.");
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
    }

    private ICompilationUnit[] findCompilationUnits() {
        ArrayList<ICompilationUnit> compUnits = new ArrayList<ICompilationUnit>();
        String[] includedFiles = this.getIncludedFiles();
        int i = 0;
        while (i < includedFiles.length) {
            Path path = new Path(includedFiles[i]);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            ICompilationUnit compUnit = JavaCore.createCompilationUnitFrom((IFile)file);
            if (compUnit != null) {
                compUnits.add(compUnit);
            }
            ++i;
        }
        return compUnits.toArray(new ICompilationUnit[compUnits.size()]);
    }

    private String[] getIncludedFiles() {
        HashSet<String> includedFiles = new HashSet<String>();
        if (this.srcdir != null || this.filesets.size() == 0) {
            FileSet fileSet = new FileSet();
            fileSet.setDir(this.getProject().resolveFile(this.srcdir != null ? this.srcdir : DEFAULT_SRCDIR));
            fileSet.setIncludes(this.includes != null ? this.includes : DEFAULT_INCLUDE);
            fileSet.setExcludes(this.excludes);
            this.filesets.add(fileSet);
        }
        for (FileSet fileSet : this.filesets) {
            DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                includedFiles.add(new File(ds.getBasedir(), files[i]).getAbsolutePath());
                ++i;
            }
        }
        return includedFiles.toArray(new String[includedFiles.size()]);
    }

    private void validateProperties() throws BuildException {
        if (!(this.mode == null || COMPLETE.equals(this.mode) || KEEP.equals(this.mode) || REPLACE.equals(this.mode))) {
            throw new BuildException("Invalid mode: " + this.mode + ". Use complete, keep or replace");
        }
        if (this.getsetOnly != null && this.getsetOnly.booleanValue() && this.excludeGetset != null && this.excludeGetset.booleanValue()) {
            throw new BuildException("Use only one of these flags: getsetOnly && excludeGetset");
        }
    }

    private void createJavadoc(ICompilationUnit[] compUnits, IProgressMonitor monitor) throws Throwable {
        if (compUnits.length == 0) {
            return;
        }
        monitor.beginTask(Constants.TITLE_JDOC_TASK, compUnits.length);
        try {
            int i = 0;
            while (i < compUnits.length) {
                ICompilationUnit compUnit = compUnits[i];
                monitor.subTask(compUnit.getElementName());
                if (monitor.isCanceled()) {
                    break;
                }
                Configuration config = this.getConfiguration(compUnit);
                if (config.isUseEclipseFormatter()) {
                    JavadocFormatter.getInstance().startFormatting(compUnit);
                }
                IEditorPart editor = this.findEditor(compUnit);
                ICompilationUnit workingCopy = this.getWorkingCopy(compUnit, editor);
                SourceManipulator sm = new SourceManipulator(workingCopy, config);
                AddJavadocRunner runner = new AddJavadocRunner(sm);
                if (editor == null) {
                    runner.run();
                    runner.checkSuccess();
                    workingCopy.commitWorkingCopy(false, null);
                    workingCopy.discardWorkingCopy();
                } else {
                    Display.getDefault().syncExec((Runnable)runner);
                    runner.checkSuccess();
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            JavadocFormatter.getInstance().stopFormatting();
            monitor.done();
        }
    }

    private IEditorPart findEditor(ICompilationUnit compUnit) throws Throwable {
        IEditorPart editor = null;
        try {
            editor = Utils.findEditor((IJavaElement)compUnit);
        }
        catch (SWTException e) {
            EditorFinder ef = new EditorFinder(compUnit);
            Display.getDefault().syncExec((Runnable)ef);
            ef.checkSuccess();
            editor = ef.getEditor();
        }
        return editor;
    }

    private ICompilationUnit getWorkingCopy(ICompilationUnit compUnit, IEditorPart editor) throws Throwable {
        WorkingCopyCreator wcc = new WorkingCopyCreator(compUnit, editor);
        if (editor == null) {
            wcc.run();
            wcc.checkSuccess();
        } else {
            Display.getDefault().syncExec((Runnable)wcc);
            wcc.checkSuccess();
        }
        return wcc.getWorkingCopy();
    }

    private Configuration getConfiguration(ICompilationUnit compUnit) {
        if (this.config != null) {
            return this.config;
        }
        this.config = ConfigurationManager.getConfiguration((ICompilationUnit)compUnit, (boolean)false);
        if (this.mode != null) {
            if (COMPLETE.equals(this.mode)) {
                this.config.setCompleteExistingJavadoc(true);
                this.config.setKeepExistingJavadoc(false);
                this.config.setReplaceExistingJavadoc(false);
            } else if (KEEP.equals(this.mode)) {
                this.config.setCompleteExistingJavadoc(false);
                this.config.setKeepExistingJavadoc(true);
                this.config.setReplaceExistingJavadoc(false);
            } else if (REPLACE.equals(this.mode)) {
                this.config.setCompleteExistingJavadoc(false);
                this.config.setKeepExistingJavadoc(false);
                this.config.setReplaceExistingJavadoc(true);
            }
        }
        if (this.commentPublic != null) {
            this.config.setVisibilityPublic(this.commentPublic.booleanValue());
        }
        if (this.commentPackage != null) {
            this.config.setVisibilityPackage(this.commentPackage.booleanValue());
        }
        if (this.commentProtected != null) {
            this.config.setVisibilityProtected(this.commentProtected.booleanValue());
        }
        if (this.commentPrivate != null) {
            this.config.setVisibilityPrivate(this.commentPrivate.booleanValue());
        }
        if (this.commentTypes != null) {
            this.config.setCommentTypes(this.commentTypes.booleanValue());
        }
        if (this.commentFields != null) {
            this.config.setCommentFields(this.commentFields.booleanValue());
        }
        if (this.commentMethods != null) {
            this.config.setCommentMethods(this.commentMethods.booleanValue());
        }
        if (this.getsetOnly != null) {
            if (this.getsetOnly.booleanValue()) {
                this.config.setCommentMethods(true);
            }
            this.config.setGetterSetterOnly(this.getsetOnly.booleanValue());
        }
        if (this.excludeGetset != null) {
            this.config.setExcludeGetterSetter(this.excludeGetset.booleanValue());
        }
        if (this.todo != null) {
            this.config.setAddTodoForAutodoc(this.todo.booleanValue());
        }
        if (this.comment != null) {
            this.config.setCreateDummyComment(this.comment.booleanValue());
        }
        if (this.single != null) {
            this.config.setSingleLineComment(this.single.booleanValue());
        }
        if (this.format != null) {
            this.config.setUseEclipseFormatter(this.format.booleanValue());
        }
        if (this.getsetFromField != null) {
            this.config.setGetterSetterFromField(this.getsetFromField.booleanValue());
        }
        if (this.getsetFromFieldFirst != null) {
            this.config.setGetterSetterFromFieldFirst(this.getsetFromFieldFirst.booleanValue());
        }
        if (this.getsetFromFieldReplace != null) {
            this.config.setGetterSetterFromFieldReplace(this.getsetFromFieldReplace.booleanValue());
        }
        if (this.includeSubpackages != null) {
            this.config.setIncludeSubPackages(this.includeSubpackages.booleanValue());
        }
        if (this.header != null) {
            this.config.setAddHeader(this.header.booleanValue());
        }
        if (this.replaceHeader != null) {
            if (this.replaceHeader.booleanValue()) {
                this.config.setAddHeader(true);
            }
            this.config.setReplaceHeader(this.replaceHeader.booleanValue());
        }
        if (this.multiHeader != null) {
            this.config.setMultiCommentHeader(this.multiHeader.booleanValue());
        }
        return this.config;
    }

    public Project getProject() {
        if (super.getProject() == null) {
            super.setProject((Project)new DummyProject());
        }
        return super.getProject();
    }

    private class AddJavadocRunner
    implements Runnable {
        private SourceManipulator sm;
        private Throwable error;

        public AddJavadocRunner(SourceManipulator sm) {
            this.sm = sm;
        }

        @Override
        public void run() {
            try {
                if (!JAutodocTask.this.headerOnly) {
                    this.sm.addJavadoc(null);
                } else {
                    this.sm.setForceAddHeader(JAutodocTask.this.headerOnly);
                    this.sm.addJavadoc(new IMember[0], null);
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        public void checkSuccess() throws Throwable {
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static class DummyProject
    extends Project {
        public DummyProject() {
            this.setBasedir("D:/Work/workspaces/runtime-plugindev/Test");
        }

        public String getName() {
            return "DummyProject";
        }

        public void log(String message) {
            System.out.println(message);
        }

        public void log(String message, int msgLevel) {
            this.log(message);
        }

        public void log(Target target, String message, int msgLevel) {
            this.log(message);
        }

        public void log(Task task, String message, int msgLevel) {
            this.log(message);
        }
    }

    private class EditorFinder
    implements Runnable {
        private Throwable error;
        private IEditorPart editor;
        private ICompilationUnit compUnit;

        public EditorFinder(ICompilationUnit compUnit) {
            this.compUnit = compUnit;
        }

        @Override
        public void run() {
            try {
                this.editor = Utils.findEditor((IJavaElement)this.compUnit);
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        public void checkSuccess() throws Throwable {
            if (this.error != null) {
                throw this.error;
            }
        }

        public IEditorPart getEditor() {
            return this.editor;
        }
    }

    private class ProgressMonitor
    extends SubProgressMonitor {
        public ProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks);
        }

        public void subTask(String name) {
            if (JAutodocTask.this.verbose && name != null && name.length() > 0) {
                JAutodocTask.this.log(name);
            }
            super.subTask(name);
        }
    }

    private class WorkingCopyCreator
    implements Runnable {
        private IEditorPart editor;
        private ICompilationUnit compUnit;
        private ICompilationUnit workingCopy;
        private Throwable error;

        public WorkingCopyCreator(ICompilationUnit compUnit, IEditorPart editor) {
            this.editor = editor;
            this.compUnit = compUnit;
        }

        @Override
        public void run() {
            try {
                this.workingCopy = Utils.getWorkingCopy((ICompilationUnit)this.compUnit, (IEditorPart)this.editor);
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        public void checkSuccess() throws Throwable {
            if (this.error != null) {
                throw this.error;
            }
        }

        public ICompilationUnit getWorkingCopy() {
            return this.workingCopy;
        }
    }
}

