/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.types;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.yakindu.base.types.Type;
import org.yakindu.base.types.TypeConstraint;

public class InferredType {
    private Type type;
    private Collection<? extends TypeConstraint> constraints;

    public InferredType(Type type) {
        this(type, Collections.emptyList());
    }

    public InferredType(Type type, Collection<TypeConstraint> constraints) {
        if (type == null) {
            throw new NullPointerException("Type may not be null.");
        }
        if (constraints == null) {
            throw new NullPointerException("Constraints may be empty but not null.");
        }
        this.type = type;
        this.constraints = constraints;
    }

    public Type getType() {
        return this.type;
    }

    public Collection<? extends TypeConstraint> getConstraints() {
        return this.constraints;
    }

    public String toString() {
        return this.type.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InferredType)) {
            return false;
        }
        InferredType other = (InferredType)obj;
        if (!EcoreUtil.equals((EObject)this.type, (EObject)other.type)) {
            return false;
        }
        for (TypeConstraint typeConstraint : this.constraints) {
            boolean foundEqual = false;
            for (TypeConstraint typeConstraint2 : other.constraints) {
                if (!EcoreUtil.equals((EObject)typeConstraint, (EObject)typeConstraint2)) continue;
                foundEqual = true;
            }
            if (foundEqual) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

