/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.types;

import com.google.inject.ImplementedBy;
import java.util.List;
import org.yakindu.base.types.DefaultTypeSystem;
import org.yakindu.base.types.InferenceResult;
import org.yakindu.base.types.InferredType;
import org.yakindu.base.types.Type;

@ImplementedBy(value=DefaultTypeSystem.class)
public interface ITypeSystem {
    public Type getVoidType();

    public Type getBooleanType();

    public Type getIntegerType();

    public Type getRealType();

    public Type getStringType();

    public boolean isVoidType(InferredType var1);

    public boolean isBooleanType(InferredType var1);

    public boolean isIntegerType(InferredType var1);

    public boolean isRealType(InferredType var1);

    public boolean isStringType(InferredType var1);

    public boolean isVoidType(Type var1);

    public boolean isBooleanType(Type var1);

    public boolean isIntegerType(Type var1);

    public boolean isRealType(Type var1);

    public boolean isStringType(Type var1);

    public Object defaultValue(InferredType var1);

    public Object defaultValue(Type var1);

    public List<Type> getTypes();

    public InferenceResult inferTypeForLiteral(Object var1);

    public InferenceResult inferType(InferredType var1, ITypeSystemOperator var2);

    public InferenceResult inferType(InferredType var1, InferredType var2, ITypeSystemOperator var3);

    public InferenceResult inferType(InferredType var1, InferredType var2, InferredType var3, ITypeSystemOperator var4);

    public static enum BinaryOperators implements ITypeSystemOperator
    {
        LOGICAL_OR("||"),
        LOGICAL_AND("&&"),
        BITWISE_OR("|"),
        BITWISE_AND("&"),
        BITWISE_XOR("^"),
        SMALLER("<"),
        SMALLER_EQUAL("<="),
        GREATER(">"),
        GREATER_EQUAL(">="),
        EQUAL("=="),
        NOT_EQUAL("!="),
        MULTIPLY("*"),
        DIV("/"),
        MOD("%"),
        ADD("+"),
        SUBTRACT("-"),
        LEFT_SHIFT("<<"),
        RIGHT_SHIFT(">>"),
        ASSIGN("="),
        ASSIGN_MULTIPLY("*="),
        ASSIGN_DIV("/="),
        ASSIGN_MOD("%="),
        ASSIGN_ADD("+="),
        ASSIGN_SUBTRACT("-="),
        ASSIGN_LEFT_SHIFT("<<="),
        ASSIGN_RIGHT_SHIFT(">>="),
        ASSIGN_BITWISE_AND("&="),
        ASSIGN_BITWISE_XOR("^="),
        ASSIGN_BITWISE_OR("|="),
        CAST("as");

        private String symbol;

        private BinaryOperators(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }
    }

    public static interface ITypeSystemOperator {
        public String getSymbol();
    }

    public static enum TernaryOperators implements ITypeSystemOperator
    {
        CONDITIONAL("?");

        private String symbol;

        private TernaryOperators(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }
    }

    public static enum UnaryOperators implements ITypeSystemOperator
    {
        LOGICAL_NOT("!"),
        POSITIVE("+"),
        NEGATIVE("-"),
        COMPLEMENT("~");

        private String symbol;

        private UnaryOperators(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }
    }
}

