/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.utils.IDiagnosable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class StorageTraversal
implements IAdaptable,
IDiagnosable {
    private Set<? extends IStorage> storages;
    private Diagnostic diagnostic;

    public StorageTraversal(Set<? extends IStorage> storages) {
        this(storages, (Diagnostic)new BasicDiagnostic("org.eclipse.emf.compare.ide", 0, null, new Object[]{storages}));
    }

    public StorageTraversal(Set<? extends IStorage> storages, Diagnostic diagnostic) {
        this.storages = storages;
        this.diagnostic = (Diagnostic)Preconditions.checkNotNull((Object)diagnostic);
    }

    public Set<? extends IStorage> getStorages() {
        return new LinkedHashSet<IStorage>(this.storages);
    }

    public void removeStorage(IStorage storage) {
        this.storages.remove(storage);
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ResourceTraversal.class) {
            ArrayList resources = Lists.newArrayListWithCapacity((int)this.storages.size());
            for (IStorage iStorage : this.storages) {
                if (iStorage instanceof IFile) {
                    resources.add((IFile)iStorage);
                    continue;
                }
                resources.add(ResourcesPlugin.getWorkspace().getRoot().getFile(iStorage.getFullPath()));
            }
            IResource[] iResourceArray = resources.toArray(new IResource[resources.size()]);
            return new ResourceTraversal(iResourceArray, 1, 0);
        }
        return null;
    }
}

