/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.xtext.base.cs2as.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.BasePlugin;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.linking.lazy.LazyLinker;

public class CS2PivotLinker
extends LazyLinker {
    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        EList errors;
        Resource eResource = model.eResource();
        if (diagnosticsConsumer != null && eResource instanceof BaseCSResource && !ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)(errors = eResource.getErrors()))) {
            BaseCSResource csResource = (BaseCSResource)eResource;
            try {
                CS2PivotResourceAdapter resourceAdapter = csResource.getCS2ASAdapter(null);
                resourceAdapter.refreshPivotMappings(diagnosticsConsumer);
            }
            catch (Exception exception) {
                Exception cause;
                Exception exception2 = cause = exception instanceof Resource.IOWrappedException ? (Exception)exception.getCause() : exception;
                if (cause instanceof IllegalLibraryException) {
                    errors.add(new LibraryDiagnostic(cause));
                }
                errors.add(new ExceptionDiagnostic(cause));
                BasePlugin.error(0, String.valueOf(csResource.getEditorName()) + " Editor linking error", cause);
            }
        }
    }

    public static class DiagnosticWrappedException
    extends WrappedException
    implements Resource.Diagnostic {
        private static final long serialVersionUID = 1L;

        public DiagnosticWrappedException(Exception exception) {
            super(exception);
        }

        public String getLocation() {
            return "unknown";
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }
    }
}

