/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainNamedElement;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryContribution;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class LibraryCSAttribution
extends AbstractAttribution
implements CS2Pivot.UnresolvedProxyMessageProvider {
    public static final LibraryCSAttribution INSTANCE = new LibraryCSAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        LibraryCS targetElement = (LibraryCS)target;
        LibraryAdapter adapter = (LibraryAdapter)((Object)PivotUtil.getAdapter(LibraryAdapter.class, (Notifier)targetElement));
        if (adapter == null) {
            adapter = new LibraryAdapter();
            targetElement.eAdapters().add((Object)adapter);
        }
        return adapter.computeLookup(targetElement, environmentView, scopeView);
    }

    @NonNull
    public EReference getEReference() {
        EReference libraryCsPackage = BaseCSPackage.Literals.LIBRARY_CS__PACKAGE;
        return libraryCsPackage;
    }

    @Nullable
    public String getMessage(@NonNull EObject context, @NonNull String linkText) {
        LibraryAdapter adapter = (LibraryAdapter)((Object)PivotUtil.getAdapter(LibraryAdapter.class, (Notifier)context));
        if (adapter != null) {
            String message = adapter.getMessage();
            return NLS.bind((String)OCLMessages.UnresolvedLibrary_ERROR_, (Object)linkText, (Object)message);
        }
        return null;
    }

    private static class LibraryAdapter
    extends AdapterImpl {
        private URI uri = null;
        private Element importedElement = null;
        private Throwable throwable = null;

        private LibraryAdapter() {
        }

        public ScopeView computeLookup(LibraryCS targetElement, EnvironmentView environmentView, ScopeView scopeView) {
            String name;
            Resource importedResource;
            EList errors;
            this.importLibrary(targetElement, environmentView);
            Element importedElement2 = this.importedElement;
            if (importedElement2 != null && (errors = (importedResource = importedElement2.eResource()).getErrors()).size() == 0 && importedElement2 instanceof DomainNamedElement && (name = ((DomainNamedElement)importedElement2).getName()) != null) {
                environmentView.addElement(name, (DomainElement)importedElement2);
            }
            return null;
        }

        public String getMessage() {
            return this.throwable != null ? this.throwable.getMessage() : null;
        }

        protected void importLibrary(LibraryCS target, EnvironmentView environmentView) {
            URI uri2;
            String name = environmentView.getName();
            if (name == null) {
                return;
            }
            StandardLibraryContribution contribution = (StandardLibraryContribution)StandardLibraryContribution.REGISTRY.get(name);
            if (contribution != null) {
                Resource resource = contribution.getResource();
                try {
                    MetaModelManager metaModelManager = environmentView.getMetaModelManager();
                    metaModelManager.installResource(resource);
                    for (EObject root : resource.getContents()) {
                        if (!(root instanceof Root)) continue;
                        for (DomainElement pkg : ((Root)root).getNestedPackage()) {
                            if (!(pkg instanceof Library)) continue;
                            environmentView.addElement(name, pkg);
                        }
                    }
                }
                catch (IllegalLibraryException e) {
                    this.throwable = e;
                }
                return;
            }
            BaseCSResource csResource = (BaseCSResource)target.eResource();
            try {
                URI newURI = URI.createURI((String)name);
                newURI = csResource.resolve(newURI);
                if (newURI.equals(this.uri)) {
                    return;
                }
                uri2 = this.uri = newURI;
                this.importedElement = null;
                this.throwable = null;
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
                return;
            }
            catch (Exception e) {
                this.throwable = e;
                return;
            }
            ArrayList<Element> importedElements = new ArrayList<Element>();
            ResourceSet csResourceSet = (ResourceSet)DomainUtil.nonNullState((Object)csResource.getResourceSet());
            MetaModelManager metaModelManager = environmentView.getMetaModelManager();
            MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)csResourceSet, (MetaModelManager)metaModelManager);
            try {
                EList errors;
                EList warnings;
                Resource importedResource = csResourceSet.getResource(uri2, true);
                EList contents = importedResource.getContents();
                if (contents.size() > 0) {
                    for (EObject content : contents) {
                        if (!(content instanceof Pivotable)) continue;
                        Element pivot = ((Pivotable)content).getPivot();
                        importedElements.add(pivot);
                        if (this.importedElement != null) continue;
                        this.importedElement = pivot;
                    }
                }
                if ((warnings = importedResource.getWarnings()).size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)DomainUtil.bind((String)OCLMessages.WarningsInURI, (Object[])new Object[]{this.uri}), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getWarnings().add((Object)resourceDiagnostic);
                }
                if ((errors = importedResource.getErrors()).size() > 0) {
                    Resource.Diagnostic diagnostic = (Resource.Diagnostic)errors.get(0);
                    if (diagnostic instanceof WrappedException) {
                        this.throwable = ((WrappedException)diagnostic).exception();
                    } else {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                        String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)("Errors in '" + this.uri + "'"), (String)"\n\t");
                        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                        csResource.getErrors().add((Object)resourceDiagnostic);
                    }
                }
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
            }
            catch (Exception e) {
                this.throwable = e;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == LibraryAdapter.class;
        }
    }
}

