/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.descriptions.JvmDeclaredTypeSignatureHashProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmTypesResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(JvmTypesResourceDescriptionStrategy.class);
    public static final String IS_NESTED_TYPE = "nestedType";
    public static final String IS_INTERFACE = "interface";
    public static final String TYPE_PARAMETERS = "typeParameters";
    public static final String SIGNATURE_HASH_KEY = "sig";
    @Inject
    private JvmDeclaredTypeSignatureHashProvider hashProvider;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, this.createLazyUserData(eObject)));
            }
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
        }
        return true;
    }

    protected Map<String, String> createLazyUserData(final EObject eObject) {
        return new ForwardingMap<String, String>(){
            private Map<String, String> delegate;

            protected Map<String, String> delegate() {
                if (this.delegate == null) {
                    ImmutableMap.Builder userData = ImmutableMap.builder();
                    JvmTypesResourceDescriptionStrategy.this.createUserData(eObject, (ImmutableMap.Builder<String, String>)userData);
                    this.delegate = userData.build();
                }
                return this.delegate;
            }
        };
    }

    protected void createUserData(EObject eObject, ImmutableMap.Builder<String, String> userData) {
        if (eObject instanceof JvmDeclaredType) {
            userData.put((Object)SIGNATURE_HASH_KEY, (Object)this.hashProvider.getHash((JvmDeclaredType)eObject));
            if (eObject.eContainer() != null) {
                userData.put((Object)IS_NESTED_TYPE, (Object)Boolean.TRUE.toString());
            }
        }
        if (eObject instanceof JvmGenericType) {
            JvmGenericType genericType = (JvmGenericType)eObject;
            if (genericType.isInterface()) {
                userData.put((Object)IS_INTERFACE, (Object)Boolean.TRUE.toString());
            }
            if (!genericType.getTypeParameters().isEmpty()) {
                String result = "<";
                Iterator iterator = genericType.getTypeParameters().iterator();
                while (iterator.hasNext()) {
                    JvmTypeParameter type = (JvmTypeParameter)iterator.next();
                    result = String.valueOf(result) + type.getSimpleName();
                    if (!iterator.hasNext()) continue;
                    result = String.valueOf(result) + ",";
                }
                result = String.valueOf(result) + ">";
                userData.put((Object)TYPE_PARAMETERS, (Object)result);
            }
        }
    }
}

