/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.common.types.access.binary.asm.AbstractBinarySignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySimpleMemberSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeArgumentSignature;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTypeSignature
extends AbstractBinarySignature {
    protected int arrayDimensions = -1;

    BinaryTypeSignature(String chars) {
        super(chars);
    }

    BinaryTypeSignature(String chars, int offset, int length) {
        super(chars, offset, length);
    }

    public String toIdentifier() {
        StringBuilder result = new StringBuilder(this.chars.length());
        this.toIdentifier(result, 0);
        return result.toString();
    }

    protected void toIdentifier(StringBuilder builder, int identifierFixup) {
        BinaryTypeSignature componentType = this.getArrayComponentType();
        if (componentType != this) {
            componentType.toIdentifier(builder, identifierFixup);
            int dim = this.getArrayDimensions();
            int i = 0;
            while (i < dim) {
                builder.append("[]");
                ++i;
            }
        } else {
            if (this.length == 1) {
                switch (this.chars.charAt(this.offset)) {
                    case 'B': {
                        builder.append("byte");
                        return;
                    }
                    case 'C': {
                        builder.append("char");
                        return;
                    }
                    case 'D': {
                        builder.append("double");
                        return;
                    }
                    case 'F': {
                        builder.append("float");
                        return;
                    }
                    case 'I': {
                        builder.append("int");
                        return;
                    }
                    case 'J': {
                        builder.append("long");
                        return;
                    }
                    case 'S': {
                        builder.append("short");
                        return;
                    }
                    case 'Z': {
                        builder.append("boolean");
                        return;
                    }
                    case 'V': {
                        builder.append("void");
                        return;
                    }
                }
            }
            int i = this.offset + identifierFixup;
            int max = this.offset + this.length - identifierFixup;
            while (i < max) {
                char c = this.chars.charAt(i);
                if (c == '/') {
                    builder.append('.');
                } else {
                    builder.append(c);
                }
                ++i;
            }
        }
    }

    public int getArrayDimensions() {
        if (this.arrayDimensions == -1) {
            try {
                int count = 0;
                while (this.chars.charAt(count + this.offset) == '[') {
                    ++count;
                }
                this.arrayDimensions = count;
                return this.arrayDimensions;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException();
            }
        }
        return this.arrayDimensions;
    }

    public BinaryTypeSignature getArrayComponentType() {
        int dimensions = this.getArrayDimensions();
        if (dimensions == 0) {
            return this;
        }
        return new BinaryTypeSignature(this.chars, this.offset + dimensions, this.length - dimensions);
    }

    public List<BinaryTypeArgumentSignature> getTypeArguments() {
        return Collections.emptyList();
    }

    public BinaryTypeSignature getOuter() {
        return null;
    }

    public BinaryTypeSignature getTypeErasure() {
        return this;
    }

    public URI getURI() {
        BinaryTypeSignature typeErasure = this.getArrayComponentType().getTypeErasure();
        switch (typeErasure.chars.charAt(typeErasure.offset)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return URIHelperConstants.PRIMITIVES_URI.appendFragment(this.toIdentifier());
            }
        }
        String identifier = typeErasure.toIdentifier();
        URI result = URIHelperConstants.OBJECTS_URI.appendSegment(identifier).appendFragment(this.toIdentifier());
        return result;
    }

    public String getTypeVariableName() {
        return null;
    }

    public BinarySimpleMemberSignature appendField(String fieldName) {
        return new BinarySimpleMemberSignature(this, fieldName, false);
    }

    public BinarySimpleMemberSignature appendMethod(String methodName) {
        return new BinarySimpleMemberSignature(this, methodName, true);
    }
}

