/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;

public class NotationHelper {
    public static View findView(Object source) {
        IAdaptable adaptable;
        Object adapter;
        if (source instanceof View) {
            return (View)source;
        }
        if (source instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)source).getAdapter(View.class)) instanceof View) {
            return (View)adapter;
        }
        EObject obj = EMFHelper.getEObject((Object)source);
        return obj instanceof View ? (View)obj : null;
    }

    public static boolean isExternalRef(View diagramElement) {
        if (diagramElement == null) {
            return false;
        }
        View primaryView = SemanticElementHelper.findTopView((EObject)diagramElement);
        if (primaryView == null) {
            return false;
        }
        EObject semanticElement = primaryView.getElement();
        if (semanticElement == null) {
            return false;
        }
        EObject parentView = primaryView.eContainer();
        if (!(parentView instanceof View)) {
            return false;
        }
        EObject parentSemanticElement = ((View)parentView).getElement();
        if (parentSemanticElement == null) {
            return false;
        }
        return parentSemanticElement != semanticElement.eContainer() && parentSemanticElement != semanticElement;
    }
}

