/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;

public class DiagramsUtil {
    public static List<Diagram> getAssociatedDiagrams(EObject element, ResourceSet resourceSet) {
        if (resourceSet == null && element != null && element.eResource() != null) {
            resourceSet = element.eResource().getResourceSet();
        }
        if (resourceSet instanceof ModelSet) {
            Resource notationResource = NotationUtils.getNotationResource((ModelSet)resourceSet);
            return DiagramsUtil.getAssociatedDiagramsFromNotationResource(element, notationResource);
        }
        return Collections.emptyList();
    }

    public static List<Diagram> getAssociatedDiagramsFromNotationResource(EObject element, Resource notationResource) {
        if (notationResource != null) {
            LinkedList<Diagram> diagrams = new LinkedList<Diagram>();
            for (EObject eObj : notationResource.getContents()) {
                Diagram diagram;
                if (!(eObj instanceof Diagram) || !element.equals((diagram = (Diagram)eObj).getElement())) continue;
                diagrams.add(diagram);
            }
            return diagrams;
        }
        return Collections.emptyList();
    }
}

