/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.model.impl;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.utils.PapyrusImageUtils;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.swt.graphics.Image;

public class PapyrusFile
implements IPapyrusFile {
    private final IFile file;

    public PapyrusFile(IFile file) {
        this.file = file;
    }

    public IFile getMainFile() {
        return this.file;
    }

    public IResource[] getAssociatedResources() {
        ArrayList<IResource> files = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = this.file.getParent().members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile && OneFileUtils.withoutFileExtension((IResource)this.file).equals(OneFileUtils.withoutFileExtension(res))) {
                    files.add(res);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return files.toArray(new IResource[0]);
    }

    public String getLabel() {
        return this.file.getName();
    }

    public int hashCode() {
        return this.getMainFile().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PapyrusFile) {
            PapyrusFile papy = (PapyrusFile)obj;
            return this.getMainFile().equals((Object)papy.getMainFile());
        }
        return super.equals(obj);
    }

    public IProject getProject() {
        return this.file.getProject();
    }

    public IContainer getParent() {
        return this.file.getParent();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getText() {
        return this.getName().substring(0, this.getName().lastIndexOf(46));
    }

    public Image getImage() {
        return PapyrusImageUtils.getDefaultIcon();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

