/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ICurrentFolderAndPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.PageMngrImpl;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.FrameworkUtil;

public class PageManagerImpl
extends PageMngrImpl
implements IPageManager {
    protected PageManagerImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider) {
        super(diSashModel, contentChangedEventProvider);
    }

    protected PageManagerImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider, ICurrentFolderAndPageMngr folderAndPageMngr) {
        super(diSashModel, contentChangedEventProvider, folderAndPageMngr);
    }

    public void closeAllOpenedPages(Object pageIdentifier) {
        while (this.isOpen(pageIdentifier)) {
            this.closePage(pageIdentifier);
        }
    }

    @Override
    public void addPage(Object pageIdentifier) {
    }

    @Override
    public List<Object> allPages() {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Resource resource : this.diSashModel.eResource().getResourceSet().getResources()) {
            if (resource == null || !resource.isLoaded() || !"notation".equals(resource.getURI().fileExtension())) continue;
            for (EObject content : resource.getContents()) {
                if (Platform.getAdapterManager().getAdapter((Object)content, IOpenable.class) == null) continue;
                result.add(content);
            }
        }
        return result;
    }

    @Override
    public void openPage(Object pageIdentifier) {
        this.diSashModel.getSashModel().addPage(this.getCurrentFolder(), pageIdentifier);
    }

    public void selectPage(final Object pageIdentifier) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PageManagerImpl.this.folderAndPageMngr.setActivePage(pageIdentifier);
            }
        });
    }

    @Override
    public void removePage(Object pageIdentifier) {
        this.closeAllOpenedPages(pageIdentifier);
    }

    public void setCurrentFolderAndPageMngr(ICurrentFolderAndPageMngr currentFolderAndPageMngr) {
        this.folderAndPageMngr = currentFolderAndPageMngr;
    }

    public <T> T execute(SashModelOperation<T> sashModelOperation) throws IllegalAccessException {
        T result;
        if (FrameworkUtil.getBundle(sashModelOperation.getClass()) != Activator.getDefault().getBundle()) {
            throw new IllegalAccessException("Attempt to access bundle-private API.");
        }
        ContentChangedEventProvider eventProvider = this.getContentChangedEventProvider();
        boolean deliver = eventProvider.isDeliver();
        eventProvider.setDeliver(false);
        try {
            result = sashModelOperation.execute(this.diSashModel);
        }
        finally {
            eventProvider.setDeliver(deliver);
        }
        return result;
    }

    public static interface SashModelOperation<T> {
        public T execute(SashWindowsMngr var1);
    }
}

