/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseOtherDiagramsCommand
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IPageManager pageManager = (IPageManager)part.getAdapter(IPageManager.class);
            ISashWindowsContainer container = (ISashWindowsContainer)part.getAdapter(ISashWindowsContainer.class);
            Object pageIdentifier = container.getActiveSashWindowsPage().getRawModel();
            if (pageIdentifier instanceof PageRef) {
                pageIdentifier = ((PageRef)pageIdentifier).getPageIdentifier();
            }
            this.execute(pageManager, pageIdentifier);
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    public void execute(IPageManager pageManager, Object pageIdentifier) {
        boolean atLeastOneDifferentPageOpen = false;
        for (Object page : pageManager.allPages()) {
            if (page == pageIdentifier || !pageManager.isOpen(page)) continue;
            atLeastOneDifferentPageOpen = true;
            break;
        }
        if (!atLeastOneDifferentPageOpen) {
            return;
        }
        pageManager.closeOtherPages(pageIdentifier);
    }
}

