/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.papyrus.uml.diagram.common.util.PathsUtil;
import org.eclipse.ui.IEditorInput;

public class URIUtil {
    private URIUtil() {
    }

    public static IFile getFile(URI uri) {
        String fileName = uri.toFileString();
        if (fileName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        }
        if (uri.toString().startsWith("platform:/resource")) {
            String path = uri.toString().substring("platform:/resource".length());
            IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            if (workspaceResource instanceof IFile) {
                return (IFile)workspaceResource;
            }
        }
        return null;
    }

    public static URI getUri(IEditorInput input) {
        return URIUtil.getUri(input, null);
    }

    public static URI getUri(IEditorInput input, String editorID) {
        String uriString = null;
        if (input instanceof URIEditorInput) {
            uriString = PathsUtil.getRelativeWorkspaceFromEditorInputWithFragment(input);
        } else {
            uriString = PathsUtil.getRelativeWorkspaceFromEditorInput(input);
            String fragment = MDTUtil.getLastOpenedDiagramPropertyForEditor(uriString, editorID);
            if (fragment != null) {
                uriString = URI.createURI((String)uriString).appendFragment(fragment).toString();
            }
        }
        if (input != null) {
            URI uri = URI.createURI((String)uriString);
            if (uri.hasFragment()) {
                return uri;
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                Resource resource = resourceSet.getResource(uri, true);
                Diagram diagram = MDTUtil.getFirstDiagramFromResource(resource);
                if (diagram != null) {
                    String fragment = resource.getURIFragment((EObject)diagram);
                    uri = uri.appendFragment(fragment);
                }
            }
            finally {
                EMFHelper.unload((ResourceSet)resourceSet);
            }
            return uri;
        }
        return null;
    }
}

