/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.helper;

import java.io.IOException;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.ui.helper.HelpDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class HelpComponentFactory {
    public static Image image = null;

    static {
        try {
            image = new Image((Device)Display.getDefault(), Activator.getDefault().getBundle().getResource("icons/help/help_contents-1.gif").openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ImageHyperlink createHelpComponent(final Composite parent, FormToolkit toolkit, final String helpText, String pToolTip, final boolean parseTags) {
        ImageHyperlink helpImage = toolkit.createImageHyperlink(parent, 0);
        helpImage.setImage(image);
        helpImage.setBackground(null);
        final String toolTip = pToolTip == null ? "Help" : pToolTip;
        helpImage.setToolTipText(toolTip);
        helpImage.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                HelpDialog dialog = new HelpDialog(parent.getShell(), Display.getDefault().getCursorLocation(), toolTip, helpText, parseTags);
                dialog.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        return helpImage;
    }

    public static ImageHyperlink createHelpComponent(Composite parent, FormToolkit toolkit, String helpText, boolean parseTags) {
        return HelpComponentFactory.createHelpComponent(parent, toolkit, helpText, null, parseTags);
    }

    public static ImageHyperlink createHelpComponent(Composite parent, FormToolkit toolkit, String helpText) {
        return HelpComponentFactory.createHelpComponent(parent, toolkit, helpText, null, false);
    }
}

