/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.GraphicalPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteAspectToolEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypePostAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DisplayAppliedStereotypePropertiesInCompartmentPostAction
extends GraphicalPostAction {
    protected Map<String, String> stereotypePropertiesToDisplay = new HashMap<String, String>();
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;
    protected static final String ICONS_ADD = "/icons/obj16/Add_16x16.gif";
    protected static final String ICONS_REMOVE = "/icons/delete.gif";
    private CheckboxTreeViewer stereotypePropertiesToShowTreeViewer;
    protected Set<String> listOfDisplayableStereotypeProperties = new HashSet<String>();
    private static final String PROPERTIES_NODE_NAME = "propertiesToDisplay";
    private static final String PROPERTY_NODE_NAME = "propertyToDisplay";

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            String nodeName = childNodes.item(i).getNodeName();
            if (PROPERTIES_NODE_NAME.equals(nodeName)) {
                NodeList propertyNodes = childNodes.item(i).getChildNodes();
                int j = 0;
                while (j < propertyNodes.getLength()) {
                    Node propertyNameNode;
                    String propertyNodeName = propertyNodes.item(j).getNodeName();
                    if (PROPERTY_NODE_NAME.equals(propertyNodeName) && (propertyNameNode = propertyNodes.item(j).getAttributes().getNamedItem("name")) != null) {
                        this.listOfDisplayableStereotypeProperties.add(propertyNameNode.getNodeValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void save(Node parentNode) {
        Element propertiesNode = ((Element)parentNode).getOwnerDocument().createElement(PROPERTIES_NODE_NAME);
        for (String propertyName : this.listOfDisplayableStereotypeProperties) {
            Element propertyNode = propertiesNode.getOwnerDocument().createElement(PROPERTY_NODE_NAME);
            propertyNode.setAttribute("name", propertyName);
            propertiesNode.appendChild(propertyNode);
        }
        ((Element)parentNode).appendChild(propertiesNode);
    }

    @Override
    public ICommand getPostCommand(final IAdaptable viewAdapter) {
        final TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        return new AbstractTransactionalCommand(editingDomain, "Modify Stereotype Properties Display", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                String stereotypesStrList = PaletteUtil.convertToCommaSeparatedRepresentation(DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.listOfDisplayableStereotypeProperties);
                AppliedStereotypeHelper.getAddAppliedStereotypePropertiesCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (String)stereotypesStrList).execute();
                AppliedStereotypeHelper.getAppliedStereotypeToDisplayCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (String)"", (String)"Compartment").execute();
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        ArrayList<String> displayedStereotypeNames = new ArrayList<String>();
        if (entryProxy instanceof IPaletteAspectToolEntryProxy) {
            for (IPostAction postAction : ((IPaletteAspectToolEntryProxy)entryProxy).getPostActions()) {
                if (!(postAction instanceof StereotypePostAction)) continue;
                for (String string : ((StereotypePostAction)postAction).getStereotypesToApply()) {
                    displayedStereotypeNames.add(string);
                }
            }
        }
        ArrayList<Stereotype> displayedStereotypes = new ArrayList<Stereotype>();
        for (Profile appliedProfile : appliedProfiles) {
            for (Stereotype stereotype : appliedProfile.getOwnedStereotypes()) {
                if (stereotype == null || !displayedStereotypeNames.contains(stereotype.getQualifiedName())) continue;
                displayedStereotypes.add(stereotype);
            }
        }
        if (displayedStereotypeNames.size() != displayedStereotypes.size()) {
            Activator.log.error("all the stereotypes were not resolved:\n" + displayedStereotypeNames + "\n" + displayedStereotypes, null);
        }
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText("Choose applied stereotype Properties to display in compartment: ");
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.stereotypePropertiesToShowTreeViewer = new CheckboxTreeViewer(composite, 2080);
        GridData layoutData = new GridData(4, 4, true, true);
        this.stereotypePropertiesToShowTreeViewer.getControl().setLayoutData((Object)layoutData);
        this.stereotypePropertiesToShowTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ITreeElement) {
                    return ((ITreeElement)element).getChildren().length > 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof ITreeElement) {
                    return ((ITreeElement)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    ArrayList<StereotypeTreeItem> stereotypeTreeItems = new ArrayList<StereotypeTreeItem>();
                    for (Object object : (List)inputElement) {
                        if (!(object instanceof Stereotype)) continue;
                        stereotypeTreeItems.add(new StereotypeTreeItem((Stereotype)object));
                    }
                    return stereotypeTreeItems.toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ITreeElement) {
                    return ((ITreeElement)parentElement).getChildren();
                }
                return new Object[0];
            }
        });
        this.stereotypePropertiesToShowTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeItemLabelProvider());
        this.stereotypePropertiesToShowTreeViewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        this.stereotypePropertiesToShowTreeViewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        this.stereotypePropertiesToShowTreeViewer.setInput(displayedStereotypes);
        return composite;
    }

    public String getPropertyName(Stereotype stereotype, Property property) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(stereotype.getQualifiedName());
        buffer.append(".");
        buffer.append(property.getName());
        return buffer.toString();
    }

    public class CheckStateListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            TreeItem[] treeItemArray = ((CheckboxTreeViewer)event.getCheckable()).getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem stereotypeItem = treeItemArray[n2];
                Stereotype stereotype = ((StereotypeTreeItem)stereotypeItem.getData()).getStereotype();
                if (stereotype == null) {
                    Activator.log.debug("impossible to find stereotype");
                    return;
                }
                TreeItem[] treeItemArray2 = stereotypeItem.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem propertyItem = treeItemArray2[n4];
                    PropertyTreeItem propertyTreeItem = (PropertyTreeItem)propertyItem.getData();
                    if (propertyTreeItem != null && propertyTreeItem.getProperty() != null) {
                        if (propertyItem.getChecked()) {
                            DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.listOfDisplayableStereotypeProperties.add(DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.getPropertyName(stereotype, ((PropertyTreeItem)propertyItem.getData()).getProperty()));
                        } else {
                            DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.listOfDisplayableStereotypeProperties.remove(DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.getPropertyName(stereotype, ((PropertyTreeItem)propertyItem.getData()).getProperty()));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public class CheckStateProvider
    implements ICheckStateProvider {
        public boolean isChecked(Object element) {
            if (element instanceof PropertyTreeItem) {
                Property property = ((PropertyTreeItem)element).getProperty();
                Stereotype stereotype = ((PropertyTreeItem)element).getParent().getStereotype();
                if (property != null && stereotype != null) {
                    String name = DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.getPropertyName(stereotype, property);
                    return DisplayAppliedStereotypePropertiesInCompartmentPostAction.this.listOfDisplayableStereotypeProperties.contains(name);
                }
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    public static interface ITreeElement {
        public ITreeElement[] getChildren();

        public ITreeElement getParent();
    }

    public class PropertyTreeItem
    implements ITreeElement {
        private Property property;
        private StereotypeTreeItem stereotypeTreeItem;

        public PropertyTreeItem(StereotypeTreeItem stereotypeTreeItem, Property property) {
            this.stereotypeTreeItem = stereotypeTreeItem;
            this.property = property;
        }

        public Property getProperty() {
            return this.property;
        }

        @Override
        public StereotypeTreeItem getParent() {
            return this.stereotypeTreeItem;
        }

        @Override
        public ITreeElement[] getChildren() {
            return new ITreeElement[0];
        }
    }

    public class StereotypeTreeItem
    implements ITreeElement {
        private Stereotype stereotype;
        private PropertyTreeItem[] propertyTreeItems;

        public StereotypeTreeItem(Stereotype stereotype) {
            this.stereotype = stereotype;
        }

        public Stereotype getStereotype() {
            return this.stereotype;
        }

        public PropertyTreeItem[] getChildren() {
            if (this.propertyTreeItems == null) {
                ArrayList<PropertyTreeItem> items = new ArrayList<PropertyTreeItem>();
                for (Property property : this.stereotype.getAllAttributes()) {
                    if (property == null) continue;
                    items.add(new PropertyTreeItem(this, property));
                }
                this.propertyTreeItems = items.toArray(new PropertyTreeItem[0]);
            }
            return this.propertyTreeItems;
        }

        @Override
        public ITreeElement getParent() {
            return null;
        }
    }

    class TreeItemLabelProvider
    extends LabelProvider {
        TreeItemLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof StereotypeTreeItem) {
                return ((StereotypeTreeItem)element).getStereotype().getQualifiedName();
            }
            if (element instanceof PropertyTreeItem) {
                return ((PropertyTreeItem)element).getProperty().getQualifiedName();
            }
            return super.getText(element);
        }
    }
}

