/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.providers.DefaultPaletteProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.uml.diagram.common.service.LocalPaletteProvider;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilteringPaletteProvider
implements IPaletteProvider {
    private DefaultPaletteProvider proxied;
    private IConfigurationElement config;
    private String[] exceptions;
    private NodeList contributions;

    public FilteringPaletteProvider(DefaultPaletteProvider proxied, String[] exceptions) {
        this.proxied = proxied;
        this.exceptions = (String[])exceptions.clone();
    }

    public boolean shouldExpose(IEditorPart editor, String entryID) {
        int i = 0;
        while (i != this.exceptions.length) {
            if (entryID.startsWith(this.exceptions[i])) {
                return true;
            }
            ++i;
        }
        return PolicyChecker.getCurrent().isInPalette(((DiagramEditor)editor).getDiagram(), entryID);
    }

    private void clearContributions() {
        try {
            Field field = this.proxied.getClass().getDeclaredField("contributions");
            field.setAccessible(true);
            List list = (List)field.get(this.proxied);
            list.clear();
        }
        catch (Exception e) {
            Activator.log.error("Failed to setup the filtering palette's configuration", (Throwable)e);
        }
    }

    private String getCustomPalette(Diagram diagram) {
        ViewPrototype proto = ViewPrototype.get((EObject)diagram);
        PapyrusDiagram pd = (PapyrusDiagram)proto.getConfiguration();
        if (pd == null) {
            return null;
        }
        return pd.getCustomPalette();
    }

    public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
        Diagram diagram = ((DiagramEditor)editor).getDiagram();
        this.clearContributions();
        this.proxied.setContributions(this.config);
        this.proxied.contributeToPalette(editor, content, root, predefinedEntries);
        String paletteURI = this.getCustomPalette(diagram);
        if (paletteURI != null && !paletteURI.isEmpty()) {
            CustomPaletteProvider provider = new CustomPaletteProvider();
            provider.setContributions(paletteURI);
            this.contributions = provider.getContributions();
            List<String> nodesID = WalkerPaletteContribution.getAllPaletteNodesID(this.contributions);
            if (!this.isCustomPaletteContributed(predefinedEntries, nodesID)) {
                provider.contributeToPalette(editor, content, root, predefinedEntries);
            }
        }
    }

    public boolean isCustomPaletteContributed(Map predefinedEntries, List<String> nodesID) {
        for (String nodeID : nodesID) {
            if (predefinedEntries.containsKey(nodeID)) continue;
            return false;
        }
        return true;
    }

    public void setContributions(IConfigurationElement configElement) {
        this.config = configElement;
    }

    public boolean provides(IOperation operation) {
        return this.proxied.provides(operation);
    }

    public void addProviderChangeListener(IProviderChangeListener listener) {
        this.proxied.addProviderChangeListener(listener);
    }

    public void removeProviderChangeListener(IProviderChangeListener listener) {
        this.proxied.removeProviderChangeListener(listener);
    }

    private static class CustomPaletteProvider
    extends LocalPaletteProvider {
        private CustomPaletteProvider() {
        }

        public void setContributions(String uri) {
            this.readXMLDocument(uri);
        }

        public NodeList getContributions() {
            return this.contributions;
        }

        @Override
        public InputStream getXmlFile(String path) throws IOException {
            return URIConverter.INSTANCE.createInputStream(URI.createURI((String)path));
        }
    }

    private static class WalkerPaletteContribution
    implements IPapyrusPaletteConstant {
        private WalkerPaletteContribution() {
        }

        public static List<String> getAllPaletteNodesID(NodeList contributions) {
            ArrayList<String> paletteNodesID = new ArrayList<String>();
            int i = 0;
            while (i < contributions.getLength()) {
                Node node = contributions.item(i);
                if ("paletteDefinition".equals(node.getNodeName())) {
                    paletteNodesID.addAll(WalkerPaletteContribution.walkDefinition(node));
                }
                ++i;
            }
            return paletteNodesID;
        }

        private static List<String> walkDefinition(Node paletteDefinitionNode) {
            ArrayList<String> paletteNodesID = new ArrayList<String>();
            NodeList nodes = paletteDefinitionNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if ("content".equals(node.getNodeName())) {
                    paletteNodesID.addAll(WalkerPaletteContribution.walkContentNode(node));
                }
                ++i;
            }
            return paletteNodesID;
        }

        private static List<String> walkContentNode(Node paletteContentNode) {
            ArrayList<String> paletteNodesID = new ArrayList<String>();
            NodeList nodes = paletteContentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                String nodeID = null;
                if ("drawer".equals(name)) {
                    nodeID = node.getAttributes().getNamedItem("id").getNodeValue();
                    paletteNodesID.add(nodeID);
                    if (node.getChildNodes().getLength() > 0) {
                        paletteNodesID.addAll(WalkerPaletteContribution.walkContentNode(node));
                    }
                } else if ("stack".equals(name)) {
                    nodeID = node.getAttributes().getNamedItem("id").getNodeValue();
                    paletteNodesID.add(nodeID);
                    if (node.getChildNodes().getLength() > 0) {
                        paletteNodesID.addAll(WalkerPaletteContribution.walkContentNode(node));
                    }
                } else if ("separator".equals(name)) {
                    nodeID = node.getAttributes().getNamedItem("id").getNodeValue();
                    paletteNodesID.add(nodeID);
                    if (node.getChildNodes().getLength() > 0) {
                        paletteNodesID.addAll(WalkerPaletteContribution.walkContentNode(node));
                    }
                } else if ("tool".equals(name)) {
                    nodeID = node.getAttributes().getNamedItem("id").getNodeValue();
                    paletteNodesID.add(nodeID);
                    if (node.getChildNodes().getLength() > 0) {
                        paletteNodesID.addAll(WalkerPaletteContribution.walkContentNode(node));
                    }
                } else if ("aspectTool".equals(name)) {
                    nodeID = node.getAttributes().getNamedItem("id").getNodeValue();
                    paletteNodesID.add(nodeID);
                    if (node.getChildNodes().getLength() > 0) {
                        paletteNodesID.addAll(WalkerPaletteContribution.walkContentNode(node));
                    }
                }
                ++i;
            }
            return paletteNodesID;
        }
    }
}

