/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.ContributeToPaletteOperation;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteStack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.diagram.common.service.IProfileDependantPaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.service.PaletteConfigurationUtils;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.ChildConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.Configuration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.DrawerConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.IconDescriptor;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.LeafConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.PaletteconfigurationPackage;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.SeparatorConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.StackConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.provider.ExtendedConnectionToolEntry;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.provider.ExtendedCreationToolEntry;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.provider.ExtendedPaletteDrawer;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.provider.IElementTypesBasedTool;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.util.PaletteconfigurationSwitch;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class ExtendedPluginPaletteProvider
extends AbstractProvider
implements IPaletteProvider,
IProfileDependantPaletteProvider {
    public static final String TYPE_NAME = "testSpecializationTypeName";
    protected ExtendedPaletteFactory paletteFactory = new ExtendedPaletteFactory();
    protected static final String PATH = "path";
    private static final String ID = "ID";
    protected String contributorID;
    protected String paletteID;
    protected List<PaletteConfiguration> contributions;
    protected Map<String, IElementTypesBasedTool> mapToolId2Entries = new HashMap<String, IElementTypesBasedTool>();
    protected static final ImageDescriptor DEFAULT_TOOL_IMAGE_DESCRIPTOR = org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.paletteconfiguration", (String)"/icons/tool.gif");
    protected static final ImageDescriptor DEFAULT_STACK_IMAGE_DESCRIPTOR = org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.paletteconfiguration", (String)"/icons/stack.gif");
    protected static ImageDescriptor DEFAULT_DRAWER_IMAGE_DESCRIPTOR = org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.paletteconfiguration", (String)"/icons/drawer.gif");
    protected Collection<String> requiredProfiles = null;

    public boolean provides(IOperation operation) {
        if (operation instanceof ContributeToPaletteOperation) {
            IEditorPart part = ((ContributeToPaletteOperation)operation).getEditor();
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getRequiredProfiles() {
        if (this.contributions == null || this.contributions.size() == 0) {
            return Collections.emptyList();
        }
        if (this.requiredProfiles == null) {
            this.requiredProfiles = new HashSet<String>();
            for (PaletteConfiguration configuration : this.contributions) {
                Collection<String> profiles = PaletteConfigurationUtils.getRequiredProfiles(configuration);
                if (profiles == null || profiles.size() <= 0) continue;
                this.requiredProfiles.addAll(profiles);
            }
        }
        return this.requiredProfiles;
    }

    public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
        if (this.contributions == null || this.contributions.size() == 0) {
            return;
        }
        for (PaletteConfiguration configuration : this.contributions) {
            EList drawerConfigurations = configuration.getDrawerConfigurations();
            if (drawerConfigurations == null || drawerConfigurations.size() <= 0) continue;
            for (DrawerConfiguration drawerConfiguration : drawerConfigurations) {
                this.generateDrawer(root, drawerConfiguration, predefinedEntries);
            }
        }
    }

    protected PaletteDrawer generateDrawer(PaletteRoot root, DrawerConfiguration drawerConfiguration, Map predefinedEntries) {
        String id = drawerConfiguration.getId();
        PaletteDrawer drawer = this.retrieveExistingEntry(predefinedEntries, id, PaletteDrawer.class);
        if (drawer == null) {
            String label = drawerConfiguration.getLabel();
            drawer = new ExtendedPaletteDrawer(label, id);
            this.completeEntry((Configuration)drawerConfiguration, (PaletteEntry)drawer);
            predefinedEntries.put(id, drawer);
            root.add((PaletteEntry)drawer);
        }
        this.generateContent(drawer, drawerConfiguration, predefinedEntries);
        return drawer;
    }

    protected void completeEntry(Configuration configuration, PaletteEntry entry) {
        entry.setDescription(configuration.getDescription());
        ImageDescriptor imageDescriptor = null;
        IconDescriptor iconDescriptor = configuration.getIcon();
        if (iconDescriptor != null) {
            String bundleID = iconDescriptor.getPluginID();
            if (bundleID == null) {
                bundleID = this.contributorID;
            }
            String iconPath = iconDescriptor.getIconPath();
            imageDescriptor = org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.imageDescriptorFromPlugin((String)bundleID, (String)iconPath);
        }
        if (imageDescriptor == null && configuration instanceof ToolConfiguration) {
            ToolConfiguration toolConfiguration = (ToolConfiguration)configuration;
        }
        if (imageDescriptor == null) {
            imageDescriptor = (ImageDescriptor)new PaletteconfigurationSwitch<ImageDescriptor>(){

                public ImageDescriptor caseDrawerConfiguration(DrawerConfiguration object) {
                    return DEFAULT_DRAWER_IMAGE_DESCRIPTOR;
                }

                public ImageDescriptor caseToolConfiguration(ToolConfiguration object) {
                    return DEFAULT_TOOL_IMAGE_DESCRIPTOR;
                }

                public ImageDescriptor caseStackConfiguration(StackConfiguration object) {
                    return DEFAULT_STACK_IMAGE_DESCRIPTOR;
                }

                public ImageDescriptor defaultCase(EObject object) {
                    return null;
                }
            }.doSwitch((EObject)configuration);
        }
        if (imageDescriptor != null) {
            entry.setLargeIcon(imageDescriptor);
            entry.setSmallIcon(imageDescriptor);
        }
    }

    protected void generateContent(PaletteDrawer drawer, DrawerConfiguration drawerConfiguration, Map predefinedEntries) {
        for (ChildConfiguration configuration : drawerConfiguration.getOwnedConfigurations()) {
            if (configuration.eClass().equals(PaletteconfigurationPackage.eINSTANCE.getStackConfiguration())) {
                this.generateStack((PaletteContainer)drawer, (StackConfiguration)configuration, predefinedEntries);
                continue;
            }
            if (configuration.eClass().equals(PaletteconfigurationPackage.eINSTANCE.getToolConfiguration())) {
                this.generateTool((PaletteContainer)drawer, (ToolConfiguration)configuration, predefinedEntries);
                continue;
            }
            if (!configuration.eClass().equals(PaletteconfigurationPackage.eINSTANCE.getSeparatorConfiguration())) continue;
            this.generateSeparator((PaletteContainer)drawer, (SeparatorConfiguration)configuration, predefinedEntries);
        }
    }

    protected CombinedTemplateCreationEntry generateTool(PaletteContainer container, ToolConfiguration configuration, Map predefinedEntries) {
        switch (configuration.getKind()) {
            case CONNECTION_TOOL: {
                return this.generateConnectionTool(container, configuration, predefinedEntries);
            }
            case CREATION_TOOL: {
                return this.generateCreationTool(container, configuration, predefinedEntries);
            }
        }
        return null;
    }

    protected CombinedTemplateCreationEntry generateConnectionTool(PaletteContainer container, ToolConfiguration configuration, Map predefinedEntries) {
        String toolID = configuration.getId();
        CombinedTemplateCreationEntry toolEntry = this.retrieveExistingEntry(predefinedEntries, toolID, CombinedTemplateCreationEntry.class);
        if (toolEntry == null) {
            String label = configuration.getLabel();
            toolEntry = new ExtendedConnectionToolEntry(toolID, label, (PaletteFactory)this.paletteFactory, (List)configuration.getElementDescriptors());
            this.completeEntry((Configuration)configuration, (PaletteEntry)toolEntry);
            container.add((PaletteEntry)toolEntry);
            predefinedEntries.put(toolID, toolEntry);
            this.mapToolId2Entries.put(toolID, (IElementTypesBasedTool)((ExtendedConnectionToolEntry)toolEntry));
        }
        return toolEntry;
    }

    protected CombinedTemplateCreationEntry generateCreationTool(PaletteContainer container, ToolConfiguration configuration, Map predefinedEntries) {
        String toolID = configuration.getId();
        CombinedTemplateCreationEntry toolEntry = this.retrieveExistingEntry(predefinedEntries, toolID, CombinedTemplateCreationEntry.class);
        if (toolEntry == null) {
            String label = configuration.getLabel();
            toolEntry = new ExtendedCreationToolEntry(toolID, label, (PaletteFactory)this.paletteFactory, (List)configuration.getElementDescriptors());
            this.completeEntry((Configuration)configuration, (PaletteEntry)toolEntry);
            container.add((PaletteEntry)toolEntry);
            predefinedEntries.put(toolID, toolEntry);
            this.mapToolId2Entries.put(toolID, (IElementTypesBasedTool)((ExtendedCreationToolEntry)toolEntry));
        }
        return toolEntry;
    }

    protected PaletteToolEntry retrieveTool(String toolID, Map predefinedEntries) {
        Object value = predefinedEntries.get(toolID);
        if (value instanceof PaletteToolEntry) {
            return (PaletteToolEntry)value;
        }
        return null;
    }

    protected PaletteStack generateStack(PaletteContainer container, StackConfiguration configuration, Map predefinedEntries) {
        String stackID = configuration.getId();
        PaletteStack stack = this.retrieveExistingEntry(predefinedEntries, stackID, PaletteStack.class);
        if (stack == null) {
            String label = configuration.getLabel();
            String description = configuration.getDescription();
            stack = new PaletteStack(stackID, label, description, DEFAULT_STACK_IMAGE_DESCRIPTOR);
            this.completeEntry((Configuration)configuration, (PaletteEntry)stack);
            predefinedEntries.put(stackID, stack);
            container.add((PaletteEntry)stack);
        }
        for (LeafConfiguration leafConfiguration : configuration.getOwnedConfigurations()) {
            if (leafConfiguration instanceof SeparatorConfiguration) {
                this.generateSeparator((PaletteContainer)stack, (SeparatorConfiguration)leafConfiguration, predefinedEntries);
                continue;
            }
            if (!(leafConfiguration instanceof ToolConfiguration)) continue;
            this.generateTool((PaletteContainer)stack, (ToolConfiguration)leafConfiguration, predefinedEntries);
        }
        return stack;
    }

    protected PaletteSeparator generateSeparator(PaletteContainer container, SeparatorConfiguration leafConfiguration, Map predefinedEntries) {
        PaletteSeparator separator = new PaletteSeparator(leafConfiguration.getId());
        container.add((PaletteEntry)separator);
        return separator;
    }

    protected <T extends PaletteEntry> T retrieveExistingEntry(Map predefinedEntries, String id, Class<T> elementClass) {
        Object value = predefinedEntries.get(id);
        if (value == null) {
            return null;
        }
        if (elementClass.isAssignableFrom(value.getClass())) {
            return (T)((PaletteEntry)value);
        }
        return null;
    }

    public void setContributions(IConfigurationElement configElement) {
        this.contributorID = configElement.getNamespaceIdentifier();
        this.paletteID = configElement.getAttribute(ID);
        String path = configElement.getAttribute(PATH);
        if (this.paletteID == null) {
            org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.log.error("Impossible to find the palette identifier for contribution " + configElement.getValue(), null);
            this.contributions = Collections.emptyList();
            return;
        }
        if (path == null) {
            org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.log.error("Impossible to find the path for contribution " + configElement.getValue(), null);
            this.contributions = Collections.emptyList();
            return;
        }
        Bundle bundle = Platform.getBundle((String)this.contributorID);
        if (bundle == null) {
            org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.log.error("Impossible to find the bundle with ID: " + this.contributorID, null);
            this.contributions = Collections.emptyList();
            return;
        }
        try {
            this.contributions = this.loadConfigurationModel(bundle, path);
        }
        catch (FileNotFoundException e) {
            org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.log.error((Throwable)e);
            this.contributions = Collections.emptyList();
        }
        catch (IOException e) {
            org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.log.error((Throwable)e);
            this.contributions = Collections.emptyList();
        }
    }

    protected List<PaletteConfiguration> loadConfigurationModel(Bundle bundle, String path) throws FileNotFoundException, IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = this.loadResourceFromPreferences((ResourceSet)resourceSet);
        if (resource == null) {
            resource = this.loadResourceFromPlugin(bundle, path, (ResourceSet)resourceSet);
        }
        if (resource == null) {
            throw new FileNotFoundException("Loading palette configuration... Impossible to find a resource for path; " + path + " for bundle: " + bundle);
        }
        resource.load(Collections.emptyMap());
        if (resource.getContents().size() > 0) {
            return new ArrayList<PaletteConfiguration>(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)PaletteconfigurationPackage.eINSTANCE.getPaletteConfiguration()));
        }
        return Collections.emptyList();
    }

    protected String getContributorID() {
        return this.contributorID;
    }

    public List<PaletteConfiguration> getContributions() {
        return this.contributions;
    }

    protected Resource loadResourceFromPreferences(ResourceSet resourceSet) {
        IPath resourcePath;
        URI uri;
        Resource resource = null;
        String path = PapyrusPalettePreferences.getPaletteRedefinition(this.paletteID);
        if (path != null && (uri = URI.createFileURI((String)(resourcePath = Activator.getDefault().getStateLocation().append(path)).toOSString())) != null && uri.isFile() && (resource = resourceSet.createResource(uri)) != null) {
            return resource;
        }
        return resource;
    }

    protected Resource loadResourceFromPlugin(Bundle bundle, String path, ResourceSet resourceSet) throws FileNotFoundException {
        Resource resource = null;
        String bundleId = null;
        URL entry = null;
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                entry = fragment.getEntry(path);
                if (entry != null) {
                    bundleId = fragment.getSymbolicName();
                }
                ++n2;
            }
        }
        if (entry == null) {
            entry = bundle.getEntry(path);
            if (entry == null) {
                throw new FileNotFoundException("Loading palette configuration... Impossible to find a resource for path; " + path + " for bundle: " + bundle);
            }
            bundleId = bundle.getSymbolicName();
        }
        resource = resourceSet.createResource(URI.createPlatformPluginURI((String)("/" + bundleId + "/" + path), (boolean)true));
        return resource;
    }

    protected Resource loadResourceFromWorkspace(String path, ResourceSet resourceSet) {
        Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)path, (boolean)true));
        return resource;
    }

    public class ExtendedPaletteFactory
    extends PaletteFactory.Adapter {
        public Tool createTool(String toolId) {
            IElementTypesBasedTool toolEntry = ExtendedPluginPaletteProvider.this.mapToolId2Entries.get(toolId);
            if (toolEntry instanceof ExtendedCreationToolEntry) {
                return new AspectUnspecifiedTypeCreationTool(((ExtendedCreationToolEntry)toolEntry).getElementTypes());
            }
            if (toolEntry instanceof ExtendedConnectionToolEntry) {
                return new AspectUnspecifiedTypeConnectionTool(((ExtendedConnectionToolEntry)toolEntry).getElementTypes());
            }
            org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator.log.warn("Impossible to create a tool for the given tool id: " + toolId + ". Tool Entry found was :" + toolEntry);
            return null;
        }
    }
}

