/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import org.eclipse.papyrus.uml.diagram.common.handlers.DeleteFromDiagramCommandHandler;
import org.eclipse.papyrus.uml.diagram.common.handlers.RenamedElementHandler;
import org.eclipse.papyrus.uml.diagram.common.providers.AbstractActionStateSourceProvider;

public class ActionStateSourceProvider
extends AbstractActionStateSourceProvider {
    public static final String DELETE_IN_DIAGRAM = "deleteInDiagram";
    public static final String RENAME_NAMED_ELEMENT = "renameNamedElement";

    public ActionStateSourceProvider() {
        this.currentState.put(DELETE_IN_DIAGRAM, "disabled");
        this.currentState.put(RENAME_NAMED_ELEMENT, "disabled");
    }

    @Override
    public String[] getProvidedSourceNames() {
        return new String[]{DELETE_IN_DIAGRAM, RENAME_NAMED_ELEMENT};
    }

    protected void refreshDeleteAction() {
        String newState;
        String oldState = (String)this.currentState.get(DELETE_IN_DIAGRAM);
        String string = newState = this.testDeleteFromDiagram() ? "enabled" : "disabled";
        if (oldState != newState) {
            this.currentState.put(DELETE_IN_DIAGRAM, newState);
            this.fireSourceChanged(0, this.currentState);
        }
    }

    protected boolean testDeleteFromDiagram() {
        DeleteFromDiagramCommandHandler handler = new DeleteFromDiagramCommandHandler();
        return this.isSelectionInDiagram() && handler.isEnabled();
    }

    @Override
    protected void refreshActions() {
        this.refreshDeleteAction();
        this.refreshRenamedNamedElement();
    }

    protected void refreshRenamedNamedElement() {
        String newState;
        RenamedElementHandler handler = new RenamedElementHandler();
        boolean newValue = handler.isEnabled();
        String oldState = (String)this.currentState.get(RENAME_NAMED_ELEMENT);
        String string = newState = newValue ? "enabled" : "disabled";
        if (oldState != newState) {
            this.currentState.put(RENAME_NAMED_ELEMENT, newState);
            this.fireSourceChanged(0, this.currentState);
        }
    }
}

