/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.papyrus.uml.diagram.common.part.CachedResourcesDiagramEditor;
import org.eclipse.papyrus.uml.diagram.common.part.CachedResourcesDocumentProvider;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.papyrus.uml.diagram.common.util.PathsUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditingDomainRegistry
extends HashMap<String, TransactionalEditingDomain>
implements IPartListener2 {
    private static EditingDomainRegistry instance = null;
    private boolean listening = false;
    private boolean changingCachedEditors = false;

    private EditingDomainRegistry() {
    }

    public static EditingDomainRegistry getInstance() {
        if (instance == null) {
            instance = new EditingDomainRegistry();
        }
        return instance;
    }

    private void startListening() {
        if (this.listening) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)instance);
            this.listening = true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected String calculateKey(String editorID, String uri) {
        String key = (uri = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(uri)) != null ? String.valueOf(editorID) + uri : editorID;
        return key;
    }

    public TransactionalEditingDomain get(String editorID, String uri) {
        this.startListening();
        String key = this.calculateKey(editorID, uri);
        TransactionalEditingDomain oldDomain = null;
        TransactionalEditingDomain newDomain = null;
        if (this.containsKey(key)) {
            oldDomain = (TransactionalEditingDomain)super.get(key);
            oldDomain.getCommandStack().flush();
            return oldDomain;
        }
        newDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        newDomain.setID(editorID);
        final NotificationFilter diagramResourceModifiedFilter = NotificationFilter.createNotifierFilter((Object)newDomain.getResourceSet()).and(NotificationFilter.createEventTypeFilter((int)3)).and(NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0));
        newDomain.getResourceSet().eAdapters().add((Object)new Adapter(){
            private Notifier myTarget;

            public Notifier getTarget() {
                return this.myTarget;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(Notification notification) {
                Object value;
                if (diagramResourceModifiedFilter.matches(notification) && (value = notification.getNewValue()) instanceof Resource) {
                    ((Resource)value).setTrackingModification(true);
                }
            }

            public void setTarget(Notifier newTarget) {
                this.myTarget = newTarget;
            }
        });
        this.put(key, newDomain);
        return newDomain;
    }

    @Override
    public TransactionalEditingDomain get(Object okey) {
        if (okey == null || !(okey instanceof String)) {
            return null;
        }
        return this.get((String)okey, null);
    }

    private String getUriFromIEditorInput(IEditorInput input) {
        String uri = null;
        if (input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getPath().toString();
            uri = MDTUtil.fullFilePathToResourceURI(uri).toString();
        } else if (input instanceof URIEditorInput) {
            uri = ((URIEditorInput)input).getURI().trimFragment().toString();
        }
        return uri;
    }

    private String getIDFromEditor(IEditorPart editor) {
        IDocumentProvider documentProvider;
        if (editor instanceof CachedResourcesDiagramEditor && (documentProvider = ((CachedResourcesDiagramEditor)editor).getDocumentProvider()) instanceof CachedResourcesDocumentProvider) {
            return ((CachedResourcesDocumentProvider)documentProvider).getEditingDomainID();
        }
        return null;
    }

    private void cleanRegistry(IWorkbenchPartReference partReference) {
        if (this.isChangingCachedEditors()) {
            return;
        }
        if (partReference instanceof IEditorReference) {
            ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = partReference.getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                editors.add(editorReference);
                ++n2;
            }
            this.cleanRegistry(editors);
        }
    }

    private void cleanRegistry(List<IEditorReference> editors) {
        ArrayList<String> keys = new ArrayList<String>();
        for (IEditorReference editor : editors) {
            IEditorPart editorPart = editor.getEditor(false);
            if (editorPart == null) continue;
            String uri = this.getUriFromIEditorInput(editorPart.getEditorInput());
            String id = this.getIDFromEditor(editorPart);
            String key = this.calculateKey(id, uri);
            keys.add(key);
        }
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String string : this.keySet()) {
            if (keys.contains(string)) continue;
            keysToRemove.add(string);
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!keysToRemove.contains(entry.getKey())) continue;
            ((TransactionalEditingDomain)entry.getValue()).dispose();
        }
        for (String string : keysToRemove) {
            this.remove(string);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.cleanRegistry(partRef);
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        this.cleanRegistry(partRef);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public boolean isChangingCachedEditors() {
        return this.changingCachedEditors;
    }

    public void setChangingCachedEditors(boolean changingCachedEditors) {
        this.changingCachedEditors = changingCachedEditors;
    }
}

