/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;

public class PortPositionLocator
implements IBorderItemLocator {
    protected IFigure parentFigure = null;
    protected int borderItemOffset = 10;
    protected Rectangle constraint = new Rectangle(0, 0, 0, 0);

    public int getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(int borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    public PortPositionLocator(IFigure parentFigure, int preferredSide) {
        this.parentFigure = parentFigure;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return this.getPreferredLocation(proposedLocation);
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x - this.borderItemOffset;
        int xMax = parentRec.x - this.borderItemOffset + parentRec.width;
        int yMin = parentRec.y - this.borderItemOffset;
        int yMax = parentRec.y - this.borderItemOffset + parentRec.height;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        Rectangle maxRect = parentRec.getCopy();
        maxRect.shrink(-this.borderItemOffset, -this.borderItemOffset);
        while (maxRect.contains(realLocation.getLocation())) {
            maxRect.shrink(1, 1);
        }
        int pos = maxRect.getPosition(realLocation.getLocation());
        switch (pos) {
            case 1: {
                realLocation.y = yMin;
                break;
            }
            case 4: {
                realLocation.y = yMax;
                break;
            }
            case 16: {
                realLocation.x = xMax;
                break;
            }
            case 8: {
                realLocation.x = xMin;
                break;
            }
            case 17: {
                realLocation.x = xMax;
                realLocation.y = yMin;
                break;
            }
            case 9: {
                realLocation.x = xMin;
                realLocation.y = yMin;
                break;
            }
            case 20: {
                realLocation.x = xMax;
                realLocation.y = yMax;
                break;
            }
            case 12: {
                realLocation.x = xMin;
                realLocation.y = yMax;
            }
        }
        return realLocation;
    }

    public int getCurrentSideOfParent() {
        int position = 0;
        if (this.constraint.x != this.parentFigure.getBounds().width - this.borderItemOffset && this.constraint.x != -this.borderItemOffset && this.constraint.y == -this.borderItemOffset) {
            position = 1;
        } else if (this.constraint.x != this.parentFigure.getBounds().width - this.borderItemOffset && this.constraint.x != -this.borderItemOffset && this.constraint.y == this.parentFigure.getBounds().height - this.borderItemOffset) {
            position = 4;
        } else if (this.constraint.x == this.parentFigure.getBounds().width - this.borderItemOffset && this.constraint.y != -this.borderItemOffset && this.constraint.y != this.parentFigure.getBounds().height - this.borderItemOffset) {
            position = 16;
        } else if (this.constraint.x == -this.borderItemOffset && this.constraint.y != -this.borderItemOffset && this.constraint.y != this.parentFigure.getBounds().height - this.borderItemOffset) {
            position = 8;
        } else if (this.constraint.x == this.parentFigure.getBounds().width - this.borderItemOffset && this.constraint.y == -this.borderItemOffset) {
            position = 17;
        } else if (this.constraint.x == -this.borderItemOffset && this.constraint.y == -this.borderItemOffset) {
            position = 9;
        } else if (this.constraint.x == this.parentFigure.getBounds().width - this.borderItemOffset && this.constraint.y == this.parentFigure.getBounds().height - this.borderItemOffset) {
            position = 20;
        } else if (this.constraint.x == -this.borderItemOffset && this.constraint.y == this.parentFigure.getBounds().height - this.borderItemOffset) {
            position = 12;
        }
        return position;
    }

    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
    }

    public void relocate(IFigure target) {
        Rectangle proposedLocation = this.constraint.getCopy();
        proposedLocation.setLocation(this.constraint.getLocation().translate(this.parentFigure.getBounds().getTopLeft()));
        Point validLocation = this.getValidLocation(proposedLocation, target).getLocation();
        target.setBounds(new Rectangle(validLocation, target.getPreferredSize()));
    }
}

