/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ids;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class MOSKittEditorIDs {
    private static final String mapModelToEditorExtensionPoint = "org.eclipse.papyrus.uml.diagram.common.modelToEditorMap";
    private static final String ATT_MODELID = "modelID";
    private static final String ATT_EDITORID = "editorID";
    private static final String ATT_LABEL = "label";
    private static Map<String, String> cachedMapModelToEditor = null;
    private static Map<String, String> cachedMapModelToLabel = null;

    public static Map<String, String> getAllExtensionModelToEditor() {
        return MOSKittEditorIDs.getExtensionsMapModelToEditor();
    }

    public static List<String> getAllExtensionsEditorIDs() {
        return new ArrayList<String>(MOSKittEditorIDs.getExtensionsMapModelToEditor().values());
    }

    protected static Map<String, String> getExtensionsMapModelToEditor() {
        if (cachedMapModelToEditor == null) {
            MOSKittEditorIDs.buildModelToEditorMap();
        }
        return cachedMapModelToEditor;
    }

    protected static void buildModelToEditorMap() {
        cachedMapModelToEditor = new HashMap<String, String>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(mapModelToEditorExtensionPoint);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            MOSKittEditorIDs.processExtensionEditor(extension, cachedMapModelToEditor);
            ++n2;
        }
    }

    protected static void processExtensionEditor(IExtension extension, Map<String, String> map) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String model = configElement.getAttribute(ATT_MODELID);
            String editor = configElement.getAttribute(ATT_EDITORID);
            map.put(model, editor);
            ++n2;
        }
    }

    public static Map<String, String> getExtensionsMapModelToLabel() {
        if (cachedMapModelToLabel == null) {
            MOSKittEditorIDs.buildMapModelToLabel();
        }
        return cachedMapModelToLabel;
    }

    protected static void buildMapModelToLabel() {
        cachedMapModelToLabel = new HashMap<String, String>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(mapModelToEditorExtensionPoint);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            MOSKittEditorIDs.processExtensionLabel(extension, cachedMapModelToLabel);
            ++n2;
        }
    }

    protected static void processExtensionLabel(IExtension extension, Map<String, String> map) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String model = configElement.getAttribute(ATT_MODELID);
            String label = configElement.getAttribute(ATT_LABEL);
            if (label != null) {
                map.put(model, label);
            }
            ++n2;
        }
    }
}

