/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.uml2.uml.Property;

public class PropertyLabelHelper
extends StereotypedElementLabelHelper {
    private static PropertyLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static PropertyLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new PropertyLabelHelper();
        }
        return labelHelper;
    }

    protected PropertyLabelHelper() {
        this.masks.put("visibility", "Visibility");
        this.masks.put("derived", "Is Derived");
        this.masks.put("name", "Name");
        this.masks.put("type", "Type");
        this.masks.put("multiplicity", "Multiplicity");
        this.masks.put("defaultValue", "Default Value");
        this.masks.put("modifiers", "Modifiers");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy == null) {
            policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"INDRIRECT_MASK_MANAGED_LABEL");
        }
        Set<String> displayValue = Collections.emptySet();
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return this.parseString(editPart, displayValue);
    }

    protected String parseString(GraphicalEditPart editPart, Collection<String> displayValue) {
        Property property = this.getUMLElement(editPart);
        if (property != null) {
            return PropertyUtil.getCustomLabel((Property)property, displayValue);
        }
        return "";
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public Property getUMLElement(GraphicalEditPart editPart) {
        View view;
        if (editPart.getModel() instanceof View && (view = (View)editPart.getModel()).getElement() instanceof Property) {
            return (Property)view.getElement();
        }
        return null;
    }
}

