/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ui.RenameParticipantsDialog;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelParticipantHelpers {
    public static Set<IResource> getResourceToFix(IFile initialFile) {
        RenameDialogRunnable runnable = new RenameDialogRunnable(initialFile);
        Display.getDefault().syncExec((Runnable)runnable);
        return new HashSet<IResource>(runnable.getFiles());
    }

    public static Set<IResource> getRelatedFiles(IFile initialFile) {
        IFile diFile;
        IContainer parent = initialFile.getParent();
        IPath initialPath = initialFile.getFullPath();
        IPath diPath = null;
        if (!"di".equalsIgnoreCase(initialPath.getFileExtension())) {
            return Collections.singleton(initialFile);
        }
        diPath = initialPath;
        HashSet<IResource> relatedFiles = new HashSet<IResource>();
        if (diPath != null && (diFile = parent.getFile(diPath.makeRelativeTo(parent.getFullPath()))).exists()) {
            try {
                IResource[] iResourceArray = diFile.getParent().members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (r.getFullPath().removeFileExtension().lastSegment().equals(diFile.getFullPath().removeFileExtension().lastSegment())) {
                        relatedFiles.add(r);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (relatedFiles.contains(initialFile)) {
            relatedFiles.remove(initialFile);
        }
        return relatedFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenameDialogRunnable
    implements Runnable {
        private IFile initialFile;
        private RenameParticipantsDialog renameParticipantsDialog;

        public RenameDialogRunnable(IFile file) {
            this.initialFile = file;
        }

        @Override
        public void run() {
            this.renameParticipantsDialog = new RenameParticipantsDialog(Display.getDefault().getActiveShell(), this.initialFile);
            this.renameParticipantsDialog.open();
        }

        public Collection<? extends IResource> getFiles() {
            return this.renameParticipantsDialog.getFiles();
        }
    }
}

