/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.emf;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.scope.IBaseIndex;
import org.eclipse.incquery.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.incquery.runtime.api.scope.IInstanceObserver;
import org.eclipse.incquery.runtime.api.scope.IncQueryBaseIndexChangeListener;
import org.eclipse.incquery.runtime.base.api.EMFBaseIndexChangeListener;
import org.eclipse.incquery.runtime.base.api.IEMFIndexingErrorListener;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;

public class EMFBaseIndexWrapper
implements IBaseIndex {
    private final NavigationHelper navigationHelper;
    Map<IIndexingErrorListener, IEMFIndexingErrorListener> indexErrorListeners = new HashMap<IIndexingErrorListener, IEMFIndexingErrorListener>();
    Map<IncQueryBaseIndexChangeListener, EMFBaseIndexChangeListener> indexChangeListeners = new HashMap<IncQueryBaseIndexChangeListener, EMFBaseIndexChangeListener>();
    Map<IInstanceObserver, EObjectObserver> instanceObservers = new HashMap<IInstanceObserver, EObjectObserver>();

    public NavigationHelper getNavigationHelper() {
        return this.navigationHelper;
    }

    public EMFBaseIndexWrapper(NavigationHelper navigationHelper) {
        this.navigationHelper = navigationHelper;
    }

    @Override
    public void resampleDerivedFeatures() {
        this.navigationHelper.resampleDerivedFeatures();
    }

    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        return (V)this.navigationHelper.coalesceTraversals(callable);
    }

    @Override
    public boolean addIndexingErrorListener(final IIndexingErrorListener listener) {
        if (this.indexErrorListeners.containsKey(listener)) {
            return false;
        }
        IEMFIndexingErrorListener emfListener = new IEMFIndexingErrorListener(){

            public void fatal(String description, Throwable t) {
                listener.fatal(description, t);
            }

            public void error(String description, Throwable t) {
                listener.error(description, t);
            }
        };
        this.indexErrorListeners.put(listener, emfListener);
        return this.navigationHelper.addIndexingErrorListener(emfListener);
    }

    @Override
    public boolean removeIndexingErrorListener(IIndexingErrorListener listener) {
        if (!this.indexErrorListeners.containsKey(listener)) {
            return false;
        }
        return this.navigationHelper.removeIndexingErrorListener(this.indexErrorListeners.remove(listener));
    }

    @Override
    public void addBaseIndexChangeListener(final IncQueryBaseIndexChangeListener listener) {
        EMFBaseIndexChangeListener emfListener = new EMFBaseIndexChangeListener(){

            public boolean onlyOnIndexChange() {
                return listener.onlyOnIndexChange();
            }

            public void notifyChanged(boolean indexChanged) {
                listener.notifyChanged(indexChanged);
            }
        };
        this.indexChangeListeners.put(listener, emfListener);
        this.navigationHelper.addBaseIndexChangeListener(emfListener);
    }

    @Override
    public void removeBaseIndexChangeListener(IncQueryBaseIndexChangeListener listener) {
        EMFBaseIndexChangeListener cListener = this.indexChangeListeners.remove(listener);
        if (cListener != null) {
            this.navigationHelper.removeBaseIndexChangeListener(cListener);
        }
    }

    @Override
    public boolean addInstanceObserver(IInstanceObserver observer, Object observedObject) {
        if (observedObject instanceof EObject) {
            boolean success;
            EObjectObserver emfObserver = this.instanceObservers.get(observer);
            if (emfObserver == null) {
                emfObserver = new EObjectObserver(observer);
                this.instanceObservers.put(observer, emfObserver);
            }
            if (success = this.navigationHelper.addLightweightEObjectObserver((LightweightEObjectObserver)emfObserver, (EObject)observedObject)) {
                ++emfObserver.usageCount;
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean removeInstanceObserver(IInstanceObserver observer, Object observedObject) {
        if (observedObject instanceof EObject) {
            EObjectObserver emfObserver = this.instanceObservers.get(observer);
            if (emfObserver == null) {
                return false;
            }
            boolean success = this.navigationHelper.removeLightweightEObjectObserver((LightweightEObjectObserver)emfObserver, (EObject)observedObject);
            if (success && --emfObserver.usageCount == 0) {
                this.instanceObservers.remove(observer);
            }
            return success;
        }
        return false;
    }

    private class EObjectObserver
    implements LightweightEObjectObserver {
        private final IInstanceObserver observer;
        int usageCount = 0;

        private EObjectObserver(IInstanceObserver observer) {
            this.observer = observer;
        }

        public void notifyFeatureChanged(EObject host, EStructuralFeature feature, Notification notification) {
            this.observer.notifyBinaryChanged(host, feature);
        }
    }
}

