/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public class MatchUpdateAdapter<Match extends IPatternMatch>
implements IMatchUpdateListener<Match> {
    IMatchProcessor<Match> appearCallback;
    IMatchProcessor<Match> disappearCallback;

    public MatchUpdateAdapter() {
    }

    public MatchUpdateAdapter(IMatchProcessor<Match> appearCallback, IMatchProcessor<Match> disappearCallback) {
        this.setAppearCallback(appearCallback);
        this.setDisappearCallback(disappearCallback);
    }

    public IMatchProcessor<Match> getAppearCallback() {
        return this.appearCallback;
    }

    public void setAppearCallback(IMatchProcessor<Match> appearCallback) {
        this.appearCallback = appearCallback;
    }

    public IMatchProcessor<Match> getDisappearCallback() {
        return this.disappearCallback;
    }

    public void setDisappearCallback(IMatchProcessor<Match> disappearCallback) {
        this.disappearCallback = disappearCallback;
    }

    @Override
    public void notifyAppearance(Match match) {
        if (this.appearCallback != null) {
            this.appearCallback.process(match);
        }
    }

    @Override
    public void notifyDisappearance(Match match) {
        if (this.disappearCallback != null) {
            this.disappearCallback.process(match);
        }
    }
}

