/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.impl.IntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class BigIntegerValueImpl
extends IntegerValueImpl {
    private static final long serialVersionUID = 6202182719851208124L;
    @NonNull
    private final BigInteger value;

    public BigIntegerValueImpl(long value) {
        this(BigInteger.valueOf(value));
    }

    public BigIntegerValueImpl(@NonNull BigInteger value) {
        this.value = value;
        assert (value != null);
    }

    @NonNull
    public IntegerValue abs() {
        BigInteger result = this.value.abs();
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public IntegerValue addInteger(@NonNull IntegerValue right) {
        BigInteger result = this.value.add(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public Double asDouble() {
        Double result = this.value.doubleValue();
        return result;
    }

    @NonNull
    public Object asEcoreObject(@NonNull IdResolver idResolver) {
        return this.value;
    }

    @NonNull
    public Integer asInteger() {
        Integer result = this.intValue();
        return result;
    }

    @NonNull
    public Number asNumber() {
        return this.value;
    }

    @NonNull
    public Object asObject() {
        return this.value;
    }

    @NonNull
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @NonNull
    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public int compareToInteger(@NonNull IntegerValue o) {
        try {
            return this.value.compareTo(o.bigIntegerValue());
        }
        catch (InvalidValueException e) {
            return this.hashCode() - o.hashCode();
        }
    }

    @NonNull
    public IntegerValue divInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("div zero", new Object[0]);
        }
        BigInteger result = this.value.divide(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(bigLeft, bigRight);
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof IntegerValue) {
                BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
                return this.value.compareTo(bigIntegerValue) == 0;
            }
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int intValue() {
        int intValue = this.value.intValue();
        return intValue;
    }

    public boolean isUnlimitedNatural() {
        return this.signum() >= 0;
    }

    public long longValue() {
        return this.value.longValue();
    }

    @NonNull
    public IntegerValue maxInteger(@NonNull IntegerValue right) {
        return this.value.compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    @NonNull
    public IntegerValue minInteger(@NonNull IntegerValue right) {
        return this.value.compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    @NonNull
    public IntegerValue modInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("mod zero", new Object[0]);
        }
        BigInteger result = this.value.remainder(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        BigInteger result = this.value.multiply(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public IntegerValue negate() {
        BigInteger result = this.value.negate();
        return ValuesUtil.integerValueOf(result);
    }

    public int signum() {
        return this.value.signum();
    }

    @NonNull
    public IntegerValue subtractInteger(@NonNull IntegerValue right) {
        BigInteger result = this.value.subtract(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    public String toString() {
        return this.value.toString();
    }
}

