/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainConstraint;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.OCLValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType
implements DomainType {
    @NonNull
    protected final DomainStandardLibrary standardLibrary;
    @NonNull
    protected final String name;

    public AbstractType(@NonNull DomainStandardLibrary standardLibrary, @NonNull String name) {
        this.standardLibrary = standardLibrary;
        this.name = name;
    }

    @Override
    @NonNull
    public ObjectValue createInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Value createInstance(@NonNull String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public abstract DomainType getCommonType(@NonNull IdResolver var1, @NonNull DomainType var2);

    @Override
    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainStandardLibrary standardLibrary) {
        return standardLibrary.getInheritance(this);
    }

    @Override
    @NonNull
    public List<? extends DomainOperation> getLocalOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<? extends DomainProperty> getLocalProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<? extends DomainType> getLocalSuperTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return this.getTypeId().getMetaTypeName();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public DomainType getNormalizedType(@NonNull DomainStandardLibrary standardLibrary) {
        return this.getInheritance(standardLibrary);
    }

    @Override
    @NonNull
    public List<? extends DomainProperty> getOwnedAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<? extends DomainConstraint> getOwnedInvariant() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<? extends DomainOperation> getOwnedOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<? extends DomainConstraint> getOwnedRule() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DomainPackage getPackage() {
        throw new UnsupportedOperationException();
    }

    public final DomainStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    @NonNull
    public DomainTypeParameters getTypeParameters() {
        return DomainTypeParameters.EMPTY_LIST;
    }

    @Override
    public boolean isEqualToUnspecializedType(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        return this == type;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean oclEquals(@NonNull OCLValue thatValue) {
        if (!(thatValue instanceof DomainType)) {
            return false;
        }
        TypeId thisTypeId = this.getTypeId();
        TypeId thatTypeId = ((DomainType)thatValue).getTypeId();
        return thisTypeId.equals(thatTypeId);
    }

    @Override
    public int oclHashCode() {
        return this.getTypeId().hashCode();
    }

    @Override
    public DomainType specializeIn(@NonNull DomainCallExp expr, DomainType selfType) {
        throw new UnsupportedOperationException();
    }
}

