/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.types.AbstractType;
import org.eclipse.ocl.examples.domain.types.IdResolver;

public class AbstractTupleType
extends AbstractType
implements DomainTupleType {
    @NonNull
    protected final TupleTypeId typeId;

    public AbstractTupleType(@NonNull DomainStandardLibrary standardLibrary, @NonNull TupleTypeId typeId) {
        super(standardLibrary, "Tuple");
        this.typeId = typeId;
    }

    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainTupleType)) {
            return false;
        }
        return standardLibrary.conformsToTupleType(this, (DomainTupleType)type);
    }

    @NonNull
    public DomainType getCommonType(@NonNull IdResolver idResolver, @NonNull DomainType type) {
        if (type != this) {
            return idResolver.getStandardLibrary().getOclAnyType();
        }
        return this;
    }

    @NonNull
    public TupleTypeId getTupleTypeId() {
        return this.typeId;
    }

    @NonNull
    public TupleTypeId getTypeId() {
        return this.typeId;
    }

    public boolean isEqualTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainTupleType)) {
            return false;
        }
        return standardLibrary.isEqualToTupleType(this, (DomainTupleType)type);
    }

    @NonNull
    public LibraryFeature lookupImplementation(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainOperation staticOperation) {
        return standardLibrary.getOclTupleType().lookupImplementation(standardLibrary, staticOperation);
    }

    public String toString() {
        return this.typeId.toString();
    }
}

