/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.AbstractFeature;
import org.eclipse.ocl.examples.domain.library.LibraryIteration;

public abstract class AbstractIteration
extends AbstractFeature
implements LibraryIteration {
    @NonNull
    protected static final Object CARRY_ON = new Object(){

        public String toString() {
            return "<<CARRY_ON>>";
        }
    };

    @Nullable
    public Object evaluateIteration(@NonNull DomainIterationManager iterationManager) {
        try {
            while (true) {
                if (!iterationManager.hasCurrent()) {
                    Object object = this.resolveTerminalValue(iterationManager);
                    return object;
                }
                Object resultVal = this.updateAccumulator(iterationManager);
                if (resultVal != CARRY_ON) {
                    Object object = resultVal;
                    return object;
                }
                iterationManager.advanceIterators();
            }
        }
        finally {
            iterationManager.dispose();
        }
    }

    @Nullable
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        return iterationManager.getAccumulatorValue();
    }

    @Nullable
    protected abstract Object updateAccumulator(@NonNull DomainIterationManager var1);

    public static class MutableObject {
        @Nullable
        private Object value;

        public MutableObject(@Nullable Object value) {
            this.value = value;
        }

        @Nullable
        public Object get() {
            return this.value;
        }

        public void set(@Nullable Object value) {
            this.value = value;
        }
    }
}

