/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.ids.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.BindingsId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdHash;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TypeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParameterIdImpl
implements TemplateParameterId {
    private final int index;
    @NonNull
    private final String name;
    private final int hashCode;

    public TemplateParameterIdImpl(@NonNull IdManager idManager, int index) {
        this.index = index;
        this.name = "$" + Integer.toString(index);
        this.hashCode = IdHash.createGlobalHash(TemplateParameterId.class, this.name);
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTemplateParameterId(this);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        if (!(that instanceof TemplateParameterId)) {
            return false;
        }
        if (this.index != ((TemplateParameterId)that).getIndex()) {
            return false;
        }
        assert (false);
        return true;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public String getLiteralName() {
        if (this == TypeId.T_1) {
            return "T_1";
        }
        if (this == TypeId.T_2) {
            return "T_2";
        }
        if (this == TypeId.T_3) {
            return "T_3";
        }
        return null;
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public OperationId getOperationId(int templateParameters, @NonNull String name, @NonNull ParametersId parametersId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public PropertyId getPropertyId(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public TemplateParameterId getTemplateParameterId(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTemplateParameters() {
        throw new UnsupportedOperationException();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    @NonNull
    public ElementId specialize(@NonNull BindingsId templateBindings) {
        ElementId elementId = (ElementId)templateBindings.get(this.index);
        assert (elementId != null);
        return elementId;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

