/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.ids.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.BindingsId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.impl.AbstractGeneralizedIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.SpecializedLambdaTypeIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.WeakHashMapOfListOfWeakReference3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizedLambdaTypeIdImpl
extends AbstractGeneralizedIdImpl<LambdaTypeId>
implements LambdaTypeId,
WeakHashMapOfListOfWeakReference3.MatchableId<String, ParametersId> {
    @NonNull
    protected final ParametersId parametersId;

    public GeneralizedLambdaTypeIdImpl(@NonNull Integer hashCode, @NonNull String name, @NonNull ParametersId parametersId) {
        super(hashCode, 0, name);
        this.parametersId = parametersId;
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitLambdaTypeId(this);
    }

    @Override
    @NonNull
    protected LambdaTypeId createSpecializedId(@NonNull BindingsId templateBindings) {
        return new SpecializedLambdaTypeIdImpl(this, templateBindings);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        StringBuilder s = new StringBuilder();
        if (this.templateParameters > 0) {
            s.append("<");
            s.append(this.templateParameters);
            s.append(">");
        }
        s.append(this.name);
        int i = 0;
        while (i < this.parametersId.size()) {
            TypeId parameterId = (TypeId)this.parametersId.get(i);
            if (i == 0) {
                s.append(' ');
                s.append(parameterId.toString());
                s.append('(');
            } else if (i != 1) {
                if (i == 2) {
                    s.append(parameterId.toString());
                } else {
                    s.append(',');
                    s.append(parameterId.toString());
                }
            }
            ++i;
        }
        s.append(") : ");
        if (this.parametersId.size() > 1) {
            s.append(((TypeId)this.parametersId.get(1)).toString());
        } else {
            s.append("?");
        }
        String string2 = s.toString();
        assert (string2 != null);
        return string2;
    }

    @Override
    @NonNull
    public LambdaTypeId getGeneralizedId() {
        return this;
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return "LambdaType";
    }

    @Override
    @NonNull
    public ParametersId getParametersId() {
        return this.parametersId;
    }

    @Override
    public boolean matches(@NonNull String thatName, @NonNull ParametersId thatParametersId) {
        if (this.parametersId != thatParametersId) {
            return false;
        }
        return this.name.equals(thatName);
    }

    @Override
    @NonNull
    public LambdaTypeId specialize(@NonNull BindingsId templateBindings) {
        return this.createSpecializedId(templateBindings);
    }
}

